/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.block.base.entity.MultiblockGeneratorBlockEntity;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public abstract class FluidMultiblockGeneratorBlockEntity
extends MultiblockGeneratorBlockEntity
implements FluidApi.BlockProvider {
    @SyncField
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(this, 4L * FluidStackHooks.bucketAmount(), this::setChanged){

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            if (toInsert.getFluid().equals(Fluids.WATER)) {
                return 0L;
            }
            return super.insert(toInsert, simulate);
        }
    };

    public FluidMultiblockGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (this.bucketInputAllowed() && !world.isClientSide && this.isActive(state)) {
            this.processBuckets();
        }
        super.serverTick(world, pos, state, blockEntity);
    }

    private void processBuckets() {
        boolean canFill;
        ItemStack inStack = this.inventory.getItem(0);
        boolean bl = canFill = this.fluidStorage.getAmount() < this.fluidStorage.getCapacity();
        if (!canFill || inStack.isEmpty() || inStack.getCount() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(inStack, updated -> this.inventory.setItem(0, (ItemStack)updated));
        FluidApi.FluidStorage candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsExtraction()) {
            return;
        }
        long moved = FluidApi.transferFirst(candidate, this.fluidStorage, this.fluidStorage.getCapacity(), false);
        if (moved == 0L) {
            ItemStack outStack = this.inventory.getItem(1);
            if (outStack.isEmpty()) {
                this.inventory.setItem(1, stackRef.getValue());
                this.inventory.setItem(0, ItemStack.EMPTY);
            } else if (outStack.getItem().equals(stackRef.getValue().getItem()) && outStack.getCount() < outStack.getMaxStackSize()) {
                outStack.grow(1);
                this.inventory.setItem(0, ItemStack.EMPTY);
            }
        }
    }

    @Override
    protected void tryConsumeInput() {
        if (this.isProducingSteam && (this.boilerStorage.getInStack().getAmount() == 0L || this.boilerStorage.getOutStack().getAmount() >= this.boilerStorage.getCapacity())) {
            return;
        }
        Optional<RecipeHolder<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent()) {
            OritechRecipe activeRecipe;
            this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().value();
            this.consumeFluidRecipeInput(activeRecipe);
        }
    }

    protected void consumeFluidRecipeInput(OritechRecipe activeRecipe) {
        int recipeTime;
        this.progress = recipeTime = (int)((float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * (1.0f / this.getEfficiencyMultiplier()));
        this.setCurrentMaxBurnTime(recipeTime);
        FluidStack fluidStack = this.fluidStorage.getStack().copyWithAmount(activeRecipe.getFluidInput().amount());
        this.fluidStorage.extract(fluidStack, false);
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        return this.getRecipe(this.fluidStorage);
    }

    protected Optional<RecipeHolder<OritechRecipe>> getRecipe(SimpleFluidStorage checkedTank) {
        return FluidMultiblockGeneratorBlockEntity.getRecipe(checkedTank, this.level, this.getOwnRecipeType());
    }

    public static Optional<RecipeHolder<OritechRecipe>> getRecipe(FluidApi.SingleSlotStorage checkedTank, Level world, OritechRecipeType ownType) {
        if (checkedTank.getStack().isEmpty()) {
            return Optional.empty();
        }
        List availableRecipes = world.getRecipeManager().getAllRecipesFor((RecipeType)ownType);
        for (RecipeHolder recipeEntry : availableRecipes) {
            OritechRecipe recipe = (OritechRecipe)recipeEntry.value();
            FluidIngredient recipeFluid = recipe.getFluidInput();
            if (!recipeFluid.matchesFluid(checkedTank.getStack()) || checkedTank.getStack().getAmount() < recipeFluid.amount()) continue;
            return Optional.of(recipeEntry);
        }
        return Optional.empty();
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 55, 35), new ScreenProvider.GuiSlot(1, 112, 35, true));
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    public boolean bucketInputAllowed() {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable Direction direction) {
        return this.fluidStorage;
    }
}

