/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.GenericPipeDuctBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.item.tools.Wrench;

public abstract class GenericPipeBlock
extends AbstractPipeBlock
implements Wrench.Wrenchable,
SimpleWaterloggedBlock {
    public static int NO_CONNECTION = 0;
    public static int CONNECTION = 1;
    public static final IntegerProperty NORTH = IntegerProperty.create((String)"north", (int)0, (int)1);
    public static final IntegerProperty EAST = IntegerProperty.create((String)"east", (int)0, (int)1);
    public static final IntegerProperty SOUTH = IntegerProperty.create((String)"south", (int)0, (int)1);
    public static final IntegerProperty WEST = IntegerProperty.create((String)"west", (int)0, (int)1);
    public static final IntegerProperty UP = IntegerProperty.create((String)"up", (int)0, (int)1);
    public static final IntegerProperty DOWN = IntegerProperty.create((String)"down", (int)0, (int)1);
    public static final BooleanProperty STRAIGHT = BooleanProperty.create((String)"straight");
    public static final VoxelShape[] THICK_SHAPES = GenericPipeBlock.createShapes(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0), Block.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0));
    public static final VoxelShape[] EXTRA_THICK_SHAPES = GenericPipeBlock.createShapes(Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0), Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0), Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0));
    public static final VoxelShape[] THIN_SHAPES = GenericPipeBlock.createShapes(Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));

    public GenericPipeBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getNorthProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)this.getEastProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)this.getSouthProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)this.getWestProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)this.getUpProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)this.getDownProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getNorthProperty(), this.getEastProperty(), this.getSouthProperty(), this.getWestProperty(), this.getUpProperty(), this.getDownProperty(), STRAIGHT, BlockStateProperties.WATERLOGGED});
    }

    @Override
    protected VoxelShape getShape(BlockState state) {
        return this.boundingShapes[this.packStates(state)];
    }

    @Override
    protected VoxelShape[] createShapes() {
        return THICK_SHAPES;
    }

    public static VoxelShape[] createShapes(VoxelShape inner, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west, VoxelShape up, VoxelShape down) {
        VoxelShape[] shapes = new VoxelShape[64];
        for (int i = 0; i <= 63; ++i) {
            VoxelShape shape = inner;
            if ((i & 1) != 0) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)north, (BooleanOp)BooleanOp.OR);
            }
            if ((i & 2) != 0) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)east, (BooleanOp)BooleanOp.OR);
            }
            if ((i & 4) != 0) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)south, (BooleanOp)BooleanOp.OR);
            }
            if ((i & 8) != 0) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)west, (BooleanOp)BooleanOp.OR);
            }
            if ((i & 0x10) != 0) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)up, (BooleanOp)BooleanOp.OR);
            }
            if ((i & 0x20) != 0) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)down, (BooleanOp)BooleanOp.OR);
            }
            shapes[i] = shape.optimize();
        }
        return shapes;
    }

    private int packStates(BlockState state) {
        int i = 0;
        if ((Integer)state.getValue((Property)this.getNorthProperty()) != NO_CONNECTION) {
            i |= 1;
        }
        if ((Integer)state.getValue((Property)this.getEastProperty()) != NO_CONNECTION) {
            i |= 2;
        }
        if ((Integer)state.getValue((Property)this.getSouthProperty()) != NO_CONNECTION) {
            i |= 4;
        }
        if ((Integer)state.getValue((Property)this.getWestProperty()) != NO_CONNECTION) {
            i |= 8;
        }
        if ((Integer)state.getValue((Property)this.getUpProperty()) != NO_CONNECTION) {
            i |= 0x10;
        }
        if ((Integer)state.getValue((Property)this.getDownProperty()) != NO_CONNECTION) {
            i |= 0x20;
        }
        return i;
    }

    @Override
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (oldState.getBlock().equals(state.getBlock())) {
            return;
        }
        if (oldState.is(this.getConnectionBlock().getBlock())) {
            GenericPipeInterfaceEntity.addNode(world, pos, false, state, this.getNetworkData(world));
            return;
        }
        if (this.hasNeighboringMachine(state, world, pos, true)) {
            BlockState connectionBlock = this.getConnectionBlock();
            BlockState interfaceState = ((GenericPipeBlock)connectionBlock.getBlock()).addConnectionStates(connectionBlock, world, pos, true);
            world.setBlockAndUpdate(pos, interfaceState);
        } else {
            GenericPipeInterfaceEntity.addNode(world, pos, false, state, this.getNetworkData(world));
        }
        this.updateNeighbors(world, pos, false);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccess, BlockPos pos, BlockPos neighborPos) {
        Level world = (Level)worldAccess;
        if (world.isClientSide) {
            return state;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (this.hasMachineInDirection(direction, world, pos, this.apiValidationFunction())) {
            boolean hasMachine = ((Set)this.getNetworkData((Level)world).machinePipeNeighbors.getOrDefault(neighborPos, HashSet.newHashSet(0))).contains(direction.getOpposite());
            if (hasMachine) {
                return state;
            }
            BlockState connectionBlock = this.getConnectionBlock();
            return ((GenericPipeBlock)connectionBlock.getBlock()).addConnectionStates(connectionBlock, world, pos, direction);
        }
        if (neighborState.is(Blocks.AIR)) {
            this.getNetworkData((Level)world).machinePipeNeighbors.remove(neighborPos);
        }
        return state;
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!state.is(newState.getBlock()) && !(newState.getBlock() instanceof GenericPipeBlock)) {
            this.onBlockRemoved(pos, state, world);
        }
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public void updateNeighbors(Level world, BlockPos pos, boolean neighborToggled) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = world.getBlockState(neighborPos);
            Block block = neighborState.getBlock();
            if (!(block instanceof AbstractPipeBlock)) continue;
            AbstractPipeBlock pipeBlock = (AbstractPipeBlock)block;
            BlockState updatedState = pipeBlock.addConnectionStates(neighborState, world, neighborPos, false);
            world.setBlockAndUpdate(neighborPos, updatedState);
            if (neighborState.equals(updatedState) && !(pipeBlock instanceof GenericPipeDuctBlock)) continue;
            boolean interfaceBlock = updatedState.is(this.getConnectionBlock().getBlock());
            if (!neighborToggled) continue;
            GenericPipeInterfaceEntity.addNode(world, neighborPos, interfaceBlock, updatedState, this.getNetworkData(world));
        }
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.isCreative() && !world.isClientSide) {
            this.onBlockRemoved(pos, state, world);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && stack.is(TagContent.WRENCHES) && !stack.is(ItemContent.WRENCH)) {
            this.onWrenchUse(state, level, pos, player, hand);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public InteractionResult onWrenchUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            this.playerWillDestroy(world, pos, state, player);
            world.destroyBlock(pos, true, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        return this.toggleSideConnection(state, this.getInteractDirection(state, pos, player), world, pos) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Override
    public InteractionResult onWrenchUseNeighbor(BlockState state, BlockState neighborState, Level world, BlockPos pos, BlockPos neighborPos, Direction neighborFace, Player player, InteractionHand hand) {
        return this.toggleSideConnection(state, neighborFace.getOpposite(), world, pos) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    protected Direction getInteractDirection(BlockState state, BlockPos pos, Player player) {
        List<VoxelShape> shapes = this.getActiveShapes(state);
        Vec3 start = player.getEyePosition(0.0f);
        Vec3 end = start.add(player.getViewVector(0.0f).scale(5.0));
        VoxelShape targetShape = shapes.getFirst();
        double distance = Double.MAX_VALUE;
        Vec3 hitPos = Vec3.ZERO;
        for (VoxelShape shape : shapes) {
            double shapeDistance;
            BlockHitResult hitResult = shape.clip(start, end, pos);
            if (hitResult == null || shape.equals(shapes.getLast()) && distance < Double.MAX_VALUE || !((shapeDistance = hitResult.getLocation().distanceTo(start)) < distance)) continue;
            distance = shapeDistance;
            targetShape = shape;
            hitPos = hitResult.getLocation();
        }
        Vec3 center = targetShape.bounds().getCenter();
        Vec3 diff = center.subtract(new Vec3(0.5, 0.5, 0.5));
        if (diff.equals((Object)Vec3.ZERO)) {
            diff = hitPos.subtract(center.add(Vec3.atLowerCornerOf((Vec3i)pos)));
        }
        return Direction.getNearest((double)diff.x, (double)diff.y, (double)diff.z);
    }

    private List<VoxelShape> getActiveShapes(BlockState state) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        if ((Integer)state.getValue((Property)this.getNorthProperty()) != NO_CONNECTION) {
            shapes.add(Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0));
        }
        if ((Integer)state.getValue((Property)this.getEastProperty()) != NO_CONNECTION) {
            shapes.add(Block.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        }
        if ((Integer)state.getValue((Property)this.getSouthProperty()) != NO_CONNECTION) {
            shapes.add(Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0));
        }
        if ((Integer)state.getValue((Property)this.getWestProperty()) != NO_CONNECTION) {
            shapes.add(Block.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0));
        }
        if ((Integer)state.getValue((Property)this.getUpProperty()) != NO_CONNECTION) {
            shapes.add(Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        }
        if ((Integer)state.getValue((Property)this.getDownProperty()) != NO_CONNECTION) {
            shapes.add(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0));
        }
        shapes.add(Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
        return shapes;
    }

    protected boolean toggleSideConnection(BlockState state, Direction side, Level world, BlockPos pos) {
        IntegerProperty property = this.directionToProperty(side);
        boolean createConnection = (Integer)state.getValue((Property)property) == NO_CONNECTION;
        BlockPos targetPos = pos.relative(side);
        if (createConnection && !this.isValidConnectionTarget(world.getBlockState(targetPos).getBlock(), world, side.getOpposite(), targetPos)) {
            return false;
        }
        int nextConnectionState = this.getNextConnectionState(state, side, world, pos, (Integer)state.getValue((Property)property));
        BlockState newState = this.addStraightState((BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(nextConnectionState)));
        if (!newState.is(this.getConnectionBlock().getBlock()) && createConnection && this.hasMachineInDirection(side, world, pos, this.apiValidationFunction())) {
            BlockState connectionState = this.getConnectionBlock();
            BlockState interfaceState = ((GenericPipeBlock)connectionState.getBlock()).addConnectionStates(connectionState, world, pos, side);
            interfaceState = this.addFluidState(interfaceState, pos, world);
            world.setBlockAndUpdate(pos, interfaceState);
        } else {
            world.setBlockAndUpdate(pos, newState);
            GenericPipeInterfaceEntity.addNode(world, pos, false, newState, this.getNetworkData(world));
            this.updateNeighbors(world, pos, true);
        }
        SoundType soundGroup = this.getSoundType(state);
        world.playSound(null, pos, soundGroup.getPlaceSound(), SoundSource.BLOCKS, soundGroup.getVolume() * 0.5f, soundGroup.getPitch());
        return true;
    }

    @Override
    public BlockState addConnectionStates(BlockState state, Level world, BlockPos pos, boolean createConnection) {
        state = this.addFluidState(state, pos, world);
        for (Direction direction : Direction.values()) {
            IntegerProperty property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, createConnection);
            state = (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(connection ? CONNECTION : NO_CONNECTION));
        }
        return this.addStraightState(state);
    }

    @Override
    public BlockState addConnectionStates(BlockState state, Level world, BlockPos pos, Direction createDirection) {
        for (Direction direction : Direction.values()) {
            IntegerProperty property = this.directionToProperty(direction);
            boolean connection = this.shouldConnect(state, direction, pos, world, direction.equals((Object)createDirection));
            state = (BlockState)state.setValue((Property)property, (Comparable)Integer.valueOf(connection ? CONNECTION : NO_CONNECTION));
        }
        return this.addFluidState(this.addStraightState(state), pos, world);
    }

    @Override
    public BlockState addStraightState(BlockState state) {
        boolean north = (Integer)state.getValue((Property)this.getNorthProperty()) != NO_CONNECTION;
        boolean south = (Integer)state.getValue((Property)this.getSouthProperty()) != NO_CONNECTION;
        boolean east = (Integer)state.getValue((Property)this.getEastProperty()) != NO_CONNECTION;
        boolean west = (Integer)state.getValue((Property)this.getWestProperty()) != NO_CONNECTION;
        boolean up = (Integer)state.getValue((Property)this.getUpProperty()) != NO_CONNECTION;
        boolean down = (Integer)state.getValue((Property)this.getDownProperty()) != NO_CONNECTION;
        boolean straightX = north && south && !east && !west && !up && !down;
        boolean straightY = up && down && !north && !south && !east && !west;
        boolean straightZ = east && west && !north && !south && !up && !down;
        boolean straight = straightX || straightY || straightZ;
        return (BlockState)state.setValue((Property)STRAIGHT, (Comparable)Boolean.valueOf(straight));
    }

    @Override
    public boolean shouldConnect(BlockState current, Direction direction, BlockPos currentPos, Level world, boolean createConnection) {
        BlockPos targetPos = currentPos.relative(direction);
        BlockState targetState = world.getBlockState(targetPos);
        if (createConnection) {
            return this.isValidConnectionTarget(targetState.getBlock(), world, direction.getOpposite(), targetPos);
        }
        Block block = targetState.getBlock();
        if (block instanceof AbstractPipeBlock) {
            AbstractPipeBlock pipeBlock = (AbstractPipeBlock)block;
            return pipeBlock.isConnectingInDirection(targetState, direction.getOpposite(), targetPos, world, false);
        }
        return this.isConnectingInDirection(current, direction, currentPos, world, false) && this.isValidInterfaceTarget(targetState.getBlock(), world, direction.getOpposite(), targetPos);
    }

    @Override
    public boolean isConnectingInDirection(BlockState current, Direction direction, BlockPos currentPos, Level world, boolean createConnection) {
        Block block = current.getBlock();
        if (!(block instanceof GenericPipeBlock)) {
            return false;
        }
        GenericPipeBlock pipeBlock = (GenericPipeBlock)block;
        IntegerProperty property = pipeBlock.directionToProperty(direction);
        return (Integer)current.getValue((Property)property) >= CONNECTION || createConnection && (Integer)current.getValue((Property)property) == NO_CONNECTION;
    }

    public int directionToPropertyValue(BlockState state, Direction direction) {
        if (direction == Direction.NORTH) {
            return (Integer)state.getValue((Property)this.getNorthProperty());
        }
        if (direction == Direction.EAST) {
            return (Integer)state.getValue((Property)this.getEastProperty());
        }
        if (direction == Direction.SOUTH) {
            return (Integer)state.getValue((Property)this.getSouthProperty());
        }
        if (direction == Direction.WEST) {
            return (Integer)state.getValue((Property)this.getWestProperty());
        }
        if (direction == Direction.UP) {
            return (Integer)state.getValue((Property)this.getUpProperty());
        }
        return (Integer)state.getValue((Property)this.getDownProperty());
    }

    public IntegerProperty directionToProperty(Direction direction) {
        if (direction == Direction.NORTH) {
            return this.getNorthProperty();
        }
        if (direction == Direction.EAST) {
            return this.getEastProperty();
        }
        if (direction == Direction.SOUTH) {
            return this.getSouthProperty();
        }
        if (direction == Direction.WEST) {
            return this.getWestProperty();
        }
        if (direction == Direction.UP) {
            return this.getUpProperty();
        }
        return this.getDownProperty();
    }

    protected int getNextConnectionState(BlockState state, Direction side, Level world, BlockPos pos, int current) {
        return current == NO_CONNECTION ? CONNECTION : NO_CONNECTION;
    }

    @Override
    protected void onBlockRemoved(BlockPos pos, BlockState oldState, Level world) {
        this.updateNeighbors(world, pos, false);
        GenericPipeInterfaceEntity.removeNode(world, pos, false, oldState, this.getNetworkData(world));
    }

    protected float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public IntegerProperty getNorthProperty() {
        return NORTH;
    }

    public IntegerProperty getEastProperty() {
        return EAST;
    }

    public IntegerProperty getSouthProperty() {
        return SOUTH;
    }

    public IntegerProperty getWestProperty() {
        return WEST;
    }

    public IntegerProperty getUpProperty() {
        return UP;
    }

    public IntegerProperty getDownProperty() {
        return DOWN;
    }
}

