/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.reactor;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.reactor.BaseReactorBlock;

public class ReactorRedstonePortBlock
extends BaseReactorBlock {
    public static final IntegerProperty PORT_MODE = IntegerProperty.create((String)"port_mode", (int)0, (int)2);

    public ReactorRedstonePortBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)PORT_MODE, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING});
        builder.add(new Property[]{PORT_MODE});
        builder.add(new Property[]{BlockStateProperties.POWER});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Integer lastMode = (Integer)state.getValue((Property)PORT_MODE);
        int cycledMode = (lastMode + 1) % 3;
        player.sendSystemMessage((Component)Component.translatable((String)("tooltip.oritech.reactor_port_mode." + cycledMode)));
        BlockState newState = (BlockState)state.setValue((Property)PORT_MODE, (Comparable)Integer.valueOf(cycledMode));
        world.setBlockAndUpdate(pos, newState);
        return InteractionResult.SUCCESS;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.getValue((Property)BlockStateProperties.POWER);
    }

    @Override
    public boolean validForWalls() {
        return true;
    }
}

