/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.api.CustomAugmentsCollection;

public abstract class Augment {
    public static final Attachment<Map<ResourceLocation, AugmentState>> ACTIVE_AUGMENTS_DATA = new Attachment<Map<ResourceLocation, AugmentState>>(){

        @Override
        public ResourceLocation identifier() {
            return Oritech.id("playeraugments");
        }

        @Override
        public Codec<Map<ResourceLocation, AugmentState>> persistenceCodec() {
            return Codec.unboundedMap((Codec)ResourceLocation.CODEC, AugmentState.CODEC);
        }

        @Override
        public StreamCodec<ByteBuf, Map<ResourceLocation, AugmentState>> networkCodec() {
            return ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)NetworkManager.getAutoCodec(AugmentState.class));
        }

        @Override
        public Supplier<Map<ResourceLocation, AugmentState>> initializer() {
            return HashMap::new;
        }
    };
    public final ResourceLocation id;
    public final boolean toggleable;

    public static void registerAttachmentTypes() {
        AttachmentApi.register(ACTIVE_AUGMENTS_DATA);
        AttachmentApi.register(CustomAugmentsCollection.PORTAL_TARGET_TYPE);
    }

    protected Augment(ResourceLocation id, boolean toggleable) {
        this.id = id;
        this.toggleable = toggleable;
    }

    public boolean isInstalled(Player player) {
        Map<ResourceLocation, AugmentState> data = AttachmentApi.getAttachmentValue((LivingEntity)player, ACTIVE_AUGMENTS_DATA);
        AugmentState state = data.getOrDefault(this.id, AugmentState.NOT_INSTALLED);
        return !state.equals((Object)AugmentState.NOT_INSTALLED);
    }

    public void installToPlayer(Player player) {
        HashMap<ResourceLocation, AugmentState> data = new HashMap<ResourceLocation, AugmentState>(AttachmentApi.getAttachmentValue((LivingEntity)player, ACTIVE_AUGMENTS_DATA));
        data.put(this.id, AugmentState.ENABLED);
        AttachmentApi.setAttachment((LivingEntity)player, ACTIVE_AUGMENTS_DATA, data);
        this.activate(player);
    }

    public void removeFromPlayer(Player player) {
        HashMap<ResourceLocation, AugmentState> data = new HashMap<ResourceLocation, AugmentState>(AttachmentApi.getAttachmentValue((LivingEntity)player, ACTIVE_AUGMENTS_DATA));
        data.put(this.id, AugmentState.NOT_INSTALLED);
        AttachmentApi.setAttachment((LivingEntity)player, ACTIVE_AUGMENTS_DATA, data);
        this.deactivate(player);
    }

    public boolean isEnabled(Player player) {
        Map<ResourceLocation, AugmentState> data = AttachmentApi.getAttachmentValue((LivingEntity)player, ACTIVE_AUGMENTS_DATA);
        return this.isEnabled(data);
    }

    public boolean isEnabled(Map<ResourceLocation, AugmentState> playerData) {
        AugmentState state = playerData.getOrDefault(this.id, AugmentState.NOT_INSTALLED);
        return state.equals((Object)AugmentState.ENABLED);
    }

    public void toggle(Player player) {
        HashMap<ResourceLocation, AugmentState> data = new HashMap<ResourceLocation, AugmentState>(AttachmentApi.getAttachmentValue((LivingEntity)player, ACTIVE_AUGMENTS_DATA));
        AugmentState state = data.getOrDefault(this.id, AugmentState.NOT_INSTALLED);
        if (state.equals((Object)AugmentState.ENABLED)) {
            state = AugmentState.DISABLED;
            this.deactivate(player);
        } else if (state.equals((Object)AugmentState.DISABLED)) {
            state = AugmentState.ENABLED;
            this.activate(player);
        }
        data.put(this.id, state);
        AttachmentApi.setAttachment((LivingEntity)player, ACTIVE_AUGMENTS_DATA, data);
    }

    public abstract void activate(Player var1);

    public abstract void deactivate(Player var1);

    public abstract void refreshServer(Player var1);

    public void refreshClient(Player player) {
    }

    public abstract int refreshInterval();

    public static enum AugmentState {
        ENABLED,
        DISABLED,
        NOT_INSTALLED;

        public static final Codec<AugmentState> CODEC;

        static {
            CODEC = Codec.INT.flatXmap(id -> DataResult.success((Object)((Object)AugmentState.values()[id])), augmentState -> DataResult.success((Object)augmentState.ordinal()));
        }
    }
}

