/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.PassiveGeneratorBlockEntity;
import rearth.oritech.block.blocks.generators.BigSolarPanelBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MultiblockMachineController;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BigSolarPanelEntity
extends PassiveGeneratorBlockEntity
implements MultiblockMachineController,
GeoBlockEntity {
    public static final RawAnimation FOLD = RawAnimation.begin().thenPlayAndHold("fold");
    public static final RawAnimation UNFOLD = RawAnimation.begin().thenPlayAndHold("unfold");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<BigSolarPanelEntity> animationController = this.getAnimationController();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    private float coreQuality = 1.0f;
    private boolean isFolded;

    public BigSolarPanelEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.BIG_SOLAR_ENTITY, pos, state);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.addMultiblockToNbt(nbt);
        nbt.putBoolean("folded", this.isFolded);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.isFolded = nbt.getBoolean("folded");
    }

    @Override
    public int getProductionRate() {
        int baseRate = ((BigSolarPanelBlock)this.getBlockState().getBlock()).productionRate;
        int skyLightLevel = this.level.getBrightness(LightLayer.SKY, this.getBlockPos());
        this.isFolded = this.level.isNight() && skyLightLevel < 12;
        return (int)(this.coreQuality * (float)baseRate);
    }

    @Override
    public boolean isProducing() {
        int skyLightLevel = this.level.getBrightness(LightLayer.SKY, this.getBlockPos());
        return !this.level.isNight() && skyLightLevel >= 12 && this.isActive(this.getBlockState());
    }

    public void sendInfoMessageToPlayer(Player player) {
        player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.generator.production_rate", (Object[])new Object[]{this.getProductionRate(), Float.valueOf(this.getCoreQuality())}));
    }

    @Override
    protected Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos pos, Level world) {
        HashSet<Tuple<BlockPos, Direction>> res = new HashSet<Tuple<BlockPos, Direction>>();
        res.add(new Tuple((Object)pos.below(), (Object)Direction.DOWN));
        res.add(new Tuple((Object)pos.south(), (Object)Direction.NORTH));
        res.add(new Tuple((Object)pos.north(), (Object)Direction.SOUTH));
        return res;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public Direction getFacingForMultiblock() {
        return Direction.NORTH;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return null;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(-1, 1, 1), new Vec3i(1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(-1, 1, 0), new Vec3i(1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, -1), new Vec3i(1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, -1));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<BigSolarPanelEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (!this.isActive(this.getBlockState())) {
                return state.setAndContinue(MachineBlockEntity.PACKAGED);
            }
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                }
                return state.setAndContinue(MachineBlockEntity.SETUP);
            }
            long timeOfDay = this.getAdjustedTimeOfDay();
            int skyLightLevel = this.level.getBrightness(LightLayer.SKY, this.getBlockPos());
            boolean isDay = timeOfDay > 0L && timeOfDay < 12500L;
            boolean bl = this.isFolded = !isDay || skyLightLevel < 12;
            if (this.isFolded) {
                return state.setAndContinue(FOLD);
            }
            if (state.isCurrentAnimation(MachineBlockEntity.IDLE)) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(UNFOLD);
        });
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.getBlockPos();
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.getLevel();
    }

    public long getAdjustedTimeOfDay() {
        return (this.level.getDayTime() + (long)this.getTimeOffset()) % 24000L;
    }

    public int getTimeOffset() {
        int base = this.worldPosition.getX() + this.worldPosition.getZ();
        return (int)(Math.sin((double)base / 60.0) * 100.0);
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public void triggerSetupAnimation() {
    }
}

