/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.ItemFilterScreenHandler;

public class ItemFilterScreen
extends BaseOwoHandledScreen<FlowLayout, ItemFilterScreenHandler> {
    public static final int FILTER_SIZE = 12;
    private ButtonComponent whiteListButton;
    private ButtonComponent nbtButton;
    private ButtonComponent componentButton;
    private final FlowLayout[] gridContainers = new FlowLayout[12];
    private Map<Integer, ItemStack> cachedItems;

    public ItemFilterScreen(ItemFilterScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    public void updateItemFilters() {
        this.cachedItems = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings().items();
        Oritech.LOGGER.debug("loading item filters: " + String.valueOf(this.cachedItems));
        for (int i = 0; i < 12; ++i) {
            ItemStack storedStack = this.cachedItems.getOrDefault(i, ItemStack.EMPTY);
            FlowLayout container = this.gridContainers[i];
            if (container.children().size() == 2) {
                container.removeChild((io.wispforest.owo.ui.core.Component)container.children().get(1));
            }
            if (storedStack.isEmpty()) continue;
            ItemComponent itemComponent = Components.item((ItemStack)storedStack);
            itemComponent.positioning(Positioning.absolute((int)1, (int)1));
            itemComponent.showOverlay(true);
            itemComponent.setTooltipFromStack(true);
            container.child((io.wispforest.owo.ui.core.Component)itemComponent);
        }
    }

    private void updateButtons() {
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings();
        MutableComponent textWhitelistTooltip = data.useWhitelist() ? Component.translatable((String)"tooltip.oritech.item_filter.whitelist") : Component.translatable((String)"tooltip.oritech.item_filter.blacklist");
        MutableComponent textNbtTooltip = data.useNbt() ? Component.translatable((String)"tooltip.oritech.item_filter.nbt") : Component.translatable((String)"tooltip.oritech.item_filter.no_nbt");
        MutableComponent textNbtComponent = data.useComponents() ? Component.translatable((String)"tooltip.oritech.item_filter.component") : Component.translatable((String)"tooltip.oritech.item_filter.no_component");
        this.whiteListButton.tooltip((Component)textWhitelistTooltip);
        this.nbtButton.tooltip((Component)textNbtTooltip);
        this.componentButton.tooltip((Component)textNbtComponent);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)166));
        GridLayout gridContainer = Containers.grid((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0), (int)3, (int)4);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 3; ++y) {
                FlowLayout slotContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)18), (Sizing)Sizing.fixed((int)18));
                BaseComponent background = Components.texture((ResourceLocation)BasicMachineScreen.ITEM_SLOT, (int)0, (int)0, (int)18, (int)18, (int)18, (int)18).positioning(Positioning.absolute((int)0, (int)0));
                int finalX = x;
                int finalY = y;
                background.mouseDown().subscribe((mouseX, mouseY, button) -> this.onItemFrameBackgroundClicked(slotContainer, finalX, finalY));
                slotContainer.child((io.wispforest.owo.ui.core.Component)background);
                int idIndex = y * 4 + x;
                this.gridContainers[idIndex] = slotContainer;
                gridContainer.child((io.wispforest.owo.ui.core.Component)slotContainer.margins(Insets.of((int)0, (int)2, (int)0, (int)1)), y, x);
            }
        }
        overlay.child((io.wispforest.owo.ui.core.Component)gridContainer.positioning(Positioning.absolute((int)5, (int)18)));
        int buttonWidth = 60;
        this.whiteListButton = Components.button((Component)Component.literal((String)"            ").append((Component)Component.translatable((String)"title.oritech.item_filter.whitelist").withColor(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> this.toggleWhitelist());
        this.whiteListButton.horizontalSizing(Sizing.fixed((int)buttonWidth));
        this.whiteListButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings().useWhitelist()));
        this.whiteListButton.textShadow(false);
        overlay.child(this.whiteListButton.positioning(Positioning.absolute((int)83, (int)18)));
        this.nbtButton = Components.button((Component)Component.literal((String)"      ").append((Component)Component.translatable((String)"title.oritech.item_filter.nbt").withColor(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> this.toggleNbt());
        this.nbtButton.horizontalSizing(Sizing.fixed((int)buttonWidth));
        this.nbtButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings().useNbt()));
        this.nbtButton.textShadow(false);
        overlay.child(this.nbtButton.positioning(Positioning.absolute((int)83, (int)38)));
        this.componentButton = Components.button((Component)Component.literal((String)"                ").append((Component)Component.translatable((String)"title.oritech.item_filter.component").withColor(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> this.toggleComponent());
        this.componentButton.horizontalSizing(Sizing.fixed((int)buttonWidth));
        this.componentButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings().useComponents()));
        this.componentButton.textShadow(false);
        overlay.child(this.componentButton.positioning(Positioning.absolute((int)83, (int)58)));
        this.addTitle(overlay);
        rootComponent.child((io.wispforest.owo.ui.core.Component)Components.texture((ResourceLocation)BasicMachineScreen.BACKGROUND, (int)0, (int)0, (int)176, (int)166, (int)176, (int)166)).child((io.wispforest.owo.ui.core.Component)overlay.positioning(Positioning.relative((int)50, (int)50)));
        this.updateButtons();
        this.updateItemFilters();
    }

    public static ButtonComponent.Renderer createToggleRenderer(Predicate<ButtonComponent> activeSupplier) {
        return (owoUIDrawContext, button, v) -> {
            RenderSystem.enableDepthTest();
            boolean isOn = activeSupplier.test(button);
            ResourceLocation normalTexture = isOn ? Oritech.id("textures/gui/modular/toggle_on.png") : Oritech.id("textures/gui/modular/toggle_off.png");
            ResourceLocation hoverTexture = isOn ? Oritech.id("textures/gui/modular/toggle_on_hover.png") : Oritech.id("textures/gui/modular/toggle_off_hover.png");
            owoUIDrawContext.blit(button.isHovered() ? hoverTexture : normalTexture, button.x(), button.y(), 30, 16, 0.0f, 0.0f, 30, 16, 30, 16);
        };
    }

    private void addTitle(FlowLayout overlay) {
        MutableComponent blockTitle = ((ItemFilterScreenHandler)this.menu).blockEntity.getBlockState().getBlock().getName();
        LabelComponent label = Components.label((Component)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((io.wispforest.owo.ui.core.Component)label.positioning(Positioning.relative((int)50, (int)2)));
    }

    private void sendUpdateToServer() {
        NetworkManager.sendToServer(new ItemFilterBlockEntity.ItemFilterPayload(((ItemFilterScreenHandler)this.menu).blockPos, ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings()));
    }

    private void toggleWhitelist() {
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings();
        boolean whitelist = data.useWhitelist();
        boolean newWhitelist = !whitelist;
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(data.useNbt(), newWhitelist, data.useComponents(), data.items());
        this.updateFilterSettings(newData);
        this.updateButtons();
        this.sendUpdateToServer();
    }

    private void toggleNbt() {
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings();
        boolean nbt = data.useNbt();
        boolean newNbt = !nbt;
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(newNbt, data.useWhitelist(), data.useComponents(), data.items());
        this.updateFilterSettings(newData);
        this.updateButtons();
        this.sendUpdateToServer();
    }

    private void toggleComponent() {
        boolean newComponent;
        ItemFilterBlockEntity.FilterData data = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings();
        boolean component = data.useComponents();
        boolean nbt = data.useNbt();
        boolean bl = newComponent = !component;
        if (newComponent) {
            nbt = true;
        }
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(nbt, data.useWhitelist(), newComponent, data.items());
        this.updateFilterSettings(newData);
        this.updateButtons();
        this.sendUpdateToServer();
    }

    private boolean onItemFrameBackgroundClicked(FlowLayout slotContainer, int x, int y) {
        return this.acceptItemStack(slotContainer, ((ItemFilterScreenHandler)this.menu).getCarried(), y * 4 + x);
    }

    public boolean acceptItemStack(ItemStack itemStack, int index) {
        return this.acceptItemStack(this.getItemContainer(index), itemStack, index);
    }

    public boolean acceptItemStack(FlowLayout slotContainer, ItemStack itemStack, int index) {
        if (slotContainer.children().size() >= 2) {
            slotContainer.removeChild((io.wispforest.owo.ui.core.Component)slotContainer.children().get(1));
        }
        if (itemStack.isEmpty()) {
            ItemFilterBlockEntity.FilterData oldData = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings();
            HashMap<Integer, ItemStack> itemFilters = new HashMap<Integer, ItemStack>(oldData.items());
            itemFilters.remove(index);
            ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(oldData.useNbt(), oldData.useWhitelist(), oldData.useComponents(), itemFilters);
            this.updateFilterSettings(newData);
            this.sendUpdateToServer();
            return false;
        }
        ItemStack displayStack = new ItemStack((ItemLike)itemStack.getItem(), 1);
        displayStack.applyComponents(itemStack.getComponents());
        ItemComponent itemComponent = Components.item((ItemStack)displayStack);
        itemComponent.positioning(Positioning.absolute((int)1, (int)1));
        itemComponent.showOverlay(true);
        itemComponent.setTooltipFromStack(true);
        slotContainer.child((io.wispforest.owo.ui.core.Component)itemComponent);
        ItemFilterBlockEntity.FilterData oldData = ((ItemFilterScreenHandler)this.menu).blockEntity.getFilterSettings();
        HashMap<Integer, ItemStack> itemFilters = new HashMap<Integer, ItemStack>(oldData.items());
        itemFilters.put(index, displayStack);
        ItemFilterBlockEntity.FilterData newData = new ItemFilterBlockEntity.FilterData(oldData.useNbt(), oldData.useWhitelist(), oldData.useComponents(), itemFilters);
        this.updateFilterSettings(newData);
        Oritech.LOGGER.debug("stored map: " + String.valueOf(itemFilters));
        this.sendUpdateToServer();
        return true;
    }

    public FlowLayout getItemContainer(int index) {
        return this.gridContainers[index];
    }

    private void updateFilterSettings(ItemFilterBlockEntity.FilterData filterData) {
        ((ItemFilterScreenHandler)this.menu).blockEntity.setFilterSettings(filterData);
        this.cachedItems = filterData.items();
    }
}

