/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.other;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import rearth.oritech.init.ItemContent;

public class MobCaptureItem
extends Item {
    public final List<EntityType<?>> targets;

    public MobCaptureItem(Item.Properties settings, List<EntityType<?>> targets) {
        super(settings);
        this.targets = targets;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        Item resultingItem = ItemContent.UNHOLY_INTELLIGENCE;
        if (entity.isDeadOrDying()) {
            return InteractionResult.PASS;
        }
        for (EntityType<?> target : this.targets) {
            if (!entity.getType().equals(target)) continue;
            stack.shrink(1);
            if (stack.isEmpty()) {
                user.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                user.setItemInHand(hand, stack);
            }
            entity.kill();
            user.level().addFreshEntity((Entity)new ItemEntity(user.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)resultingItem)));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.capture_item_desc_1"));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.capture_item_desc_2"));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.capture_item_desc_3"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }
}

