/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ApiLookupCache<T> {
    private WeakReference<BlockEntity> cachedEntity;
    private WeakReference<T> cachedTarget;
    private BlockState lastBlockState;
    private final BlockPos targetPos;
    private final Direction direction;
    private final Level world;
    private final LookupFunction<T> lookupFunction;

    private ApiLookupCache(BlockEntity cachedEntity, T cachedTarget, BlockPos targetPos, Direction direction, Level world, LookupFunction<T> lookupFunction) {
        this.cachedEntity = new WeakReference<BlockEntity>(cachedEntity);
        this.cachedTarget = new WeakReference<T>(cachedTarget);
        this.targetPos = targetPos;
        this.direction = direction;
        this.world = world;
        this.lookupFunction = lookupFunction;
        this.lastBlockState = world.getBlockState(targetPos);
    }

    public static <T> ApiLookupCache<T> create(BlockPos targetPos, Direction direction, Level world, LookupFunction<T> lookupFunction) {
        BlockState state = world.getBlockState(targetPos);
        BlockEntity entity = world.getBlockEntity(targetPos);
        T target = lookupFunction.invoke(world, targetPos, state, entity, direction);
        return new ApiLookupCache<T>(entity, target, targetPos, direction, world, lookupFunction);
    }

    public T lookup() {
        if (this.isCacheValid()) {
            return this.cachedTarget.get();
        }
        this.cachedTarget = new WeakReference<Object>(null);
        this.cachedEntity = new WeakReference<Object>(null);
        this.refresh();
        return this.cachedTarget.get();
    }

    private void refresh() {
        BlockState currentState = this.world.getBlockState(this.targetPos);
        if (currentState.equals(this.lastBlockState)) {
            return;
        }
        BlockEntity entity = this.world.getBlockEntity(this.targetPos);
        Object target = null;
        if (entity != null) {
            target = this.lookupFunction.invoke(this.world, this.targetPos, currentState, entity, this.direction);
        }
        this.cachedTarget = new WeakReference<Object>(target);
        this.cachedEntity = new WeakReference<BlockEntity>(entity);
        this.lastBlockState = currentState;
    }

    private boolean isCacheValid() {
        BlockEntity entity = (BlockEntity)this.cachedEntity.get();
        Object target = this.cachedTarget.get();
        if (entity == null || entity.isRemoved()) {
            return false;
        }
        return target != null;
    }

    @FunctionalInterface
    public static interface LookupFunction<T> {
        public T invoke(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4, @Nullable Direction var5);
    }
}

