/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.wispforest.owo.registration.reflect.FieldProcessingSubject;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public interface ArchitecturyRegistryContainer<T>
extends FieldProcessingSubject<T> {
    public ResourceKey<Registry<T>> getRegistryType();

    default public void postProcessField(String namespace, T value, String identifier, Field field, RegistrySupplier<T> supplier) {
    }

    public static <T> void register(Class<? extends ArchitecturyRegistryContainer<T>> clazz, String namespace, boolean recurseIntoInnerClasses) {
        ArchitecturyRegistryContainer container = (ArchitecturyRegistryContainer)ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        DeferredRegister registry = DeferredRegister.create((String)namespace, container.getRegistryType());
        ReflectionUtils.iterateAccessibleStaticFields(clazz, (Class)container.getTargetFieldType(), ArchitecturyRegistryContainer.createProcessor((fieldValue, identifier, field) -> {
            RegistrySupplier supplier = registry.register(identifier, () -> fieldValue);
            container.postProcessField(namespace, fieldValue, identifier, field, supplier);
        }, container));
        registry.register();
        container.afterFieldProcessing();
    }

    private static <T> ReflectionUtils.FieldConsumer<T> createProcessor(ReflectionUtils.FieldConsumer<T> delegate, FieldProcessingSubject<T> handler) {
        return (value, name, field) -> {
            if (!handler.shouldProcessField(value, name, field)) {
                return;
            }
            delegate.accept(value, name, field);
        };
    }
}

