/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.model.util;

import com.iafenvoy.uranus.Uranus;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.TabulaModelHandler;
import com.iafenvoy.uranus.client.model.tabula.TabulaModelContainer;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class TabulaModelHandlerHelper {
    private static final Map<ResourceLocation, TabulaModelContainer> MODELS = new HashMap<ResourceLocation, TabulaModelContainer>();

    public static void reloadModel(ResourceManager manager) {
        MODELS.clear();
        for (Map.Entry entry : manager.listResources("models/tabula", id -> id.getPath().endsWith(".tbl")).entrySet()) {
            ResourceLocation id2 = (ResourceLocation)entry.getKey();
            try {
                MODELS.put(id2, TabulaModelHandler.INSTANCE.loadTabulaModel(TabulaModelHandlerHelper.getModelJsonStream(id2.toString(), ((Resource)entry.getValue()).open())));
            }
            catch (Exception e) {
                Uranus.LOGGER.error("Failed to load tabula {}", (Object)id2.toString(), (Object)e);
            }
        }
        Uranus.LOGGER.info("Successfully load {} tabula models", (Object)MODELS.size());
    }

    @Nullable
    public static TabulaModelContainer getContainer(ResourceLocation id) {
        return MODELS.get(id);
    }

    @Nullable
    public static <T extends Entity> TabulaModel<T> getModel(ResourceLocation id) {
        return TabulaModelHandlerHelper.getModel(id, null);
    }

    @Nullable
    public static <T extends Entity> TabulaModel<T> getModel(ResourceLocation id, Supplier<ITabulaModelAnimator<T>> tabulaAnimator) {
        return TabulaModelHandlerHelper.getModel(id, new MemorizeSupplier<ITabulaModelAnimator<T>>(tabulaAnimator));
    }

    @Nullable
    public static <T extends Entity> TabulaModel<T> getModel(ResourceLocation id, MemorizeSupplier<ITabulaModelAnimator<T>> tabulaAnimator) {
        try {
            String path = "models/tabula/" + id.getPath();
            if (!path.endsWith(".tbl")) {
                path = path + ".tbl";
            }
            if (MODELS.containsKey(id = id.withPath(path))) {
                return new TabulaModel<T>(MODELS.get(id), tabulaAnimator);
            }
        }
        catch (Exception e) {
            Uranus.LOGGER.error("Failed to load model {}", (Object)id, (Object)e);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static TabulaModelContainer loadTabulaModel(String path) throws IOException {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith(".tbl")) {
            path = (String)path + ".tbl";
        }
        InputStream stream = Minecraft.getInstance().getResourceManager().open(ResourceLocation.tryParse((String)path));
        return TabulaModelHandler.INSTANCE.loadTabulaModel(TabulaModelHandlerHelper.getModelJsonStream((String)path, stream));
    }

    private static InputStream getModelJsonStream(String name, InputStream file) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(file);
        do {
            if ((entry = zip.getNextEntry()) != null) continue;
            throw new RuntimeException("No model.json present in " + name);
        } while (!entry.getName().equals("model.json"));
        return zip;
    }
}

