/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.enchantment.Enchantment;

public class RegistryHelper {
    public static <T> T get(RegistryAccess manager, ResourceKey<Registry<T>> registry, ResourceKey<T> key) {
        return (T)manager.registryOrThrow(registry).get(key);
    }

    public static <T> Holder<T> entry(RegistryAccess manager, ResourceKey<Registry<T>> registry, T obj) {
        return manager.registryOrThrow(registry).wrapAsHolder(obj);
    }

    public static <T> Holder<T> getEntry(RegistryAccess manager, ResourceKey<Registry<T>> registry, ResourceKey<T> key) {
        return RegistryHelper.entry(manager, registry, RegistryHelper.get(manager, registry, key));
    }

    public static Holder<Enchantment> getEnchantment(RegistryAccess manager, ResourceKey<Enchantment> key) {
        return RegistryHelper.getEntry(manager, Registries.ENCHANTMENT, key);
    }

    public static Holder<ArmorMaterial> getArmorMaterial(RegistryAccess manager, ResourceKey<ArmorMaterial> key) {
        return RegistryHelper.getEntry(manager, Registries.ARMOR_MATERIAL, key);
    }

    public static Holder<DamageType> getDamageSource(RegistryAccess manager, ResourceKey<DamageType> key) {
        return RegistryHelper.getEntry(manager, Registries.DAMAGE_TYPE, key);
    }
}

