/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.collision;

import com.google.common.collect.AbstractIterator;
import com.iafenvoy.uranus.object.entity.collision.ICustomCollisions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CustomCollisionsBlockCollisions
extends AbstractIterator<VoxelShape> {
    private final AABB box;
    private final CollisionContext context;
    private final Cursor3D cursor;
    private final BlockPos.MutableBlockPos pos;
    private final VoxelShape entityShape;
    private final CollisionGetter collisionGetter;
    private final boolean onlySuffocatingBlocks;
    private BlockGetter cachedBlockGetter;
    private long cachedBlockGetterPos;

    public CustomCollisionsBlockCollisions(CollisionGetter collisionView, Entity entity, AABB box) {
        this(collisionView, entity, box, false);
    }

    public CustomCollisionsBlockCollisions(CollisionGetter collisionView, Entity entity, AABB box, boolean onlySuffocatingBlocks) {
        this.context = entity == null ? CollisionContext.empty() : CollisionContext.of((Entity)entity);
        this.pos = new BlockPos.MutableBlockPos();
        this.entityShape = Shapes.create((AABB)box);
        this.collisionGetter = collisionView;
        this.box = box;
        this.onlySuffocatingBlocks = onlySuffocatingBlocks;
        int i = Mth.floor((double)(box.minX - 1.0E-7)) - 1;
        int j = Mth.floor((double)(box.maxX + 1.0E-7)) + 1;
        int k = Mth.floor((double)(box.minY - 1.0E-7)) - 1;
        int l = Mth.floor((double)(box.maxY + 1.0E-7)) + 1;
        int i1 = Mth.floor((double)(box.minZ - 1.0E-7)) - 1;
        int j1 = Mth.floor((double)(box.maxZ + 1.0E-7)) + 1;
        this.cursor = new Cursor3D(i, k, i1, j, l, j1);
    }

    private BlockGetter getChunk(int p_186412_, int p_186413_) {
        BlockGetter blockView;
        int i = SectionPos.blockToSectionCoord((int)p_186412_);
        int j = SectionPos.blockToSectionCoord((int)p_186413_);
        long k = ChunkPos.asLong((int)i, (int)j);
        if (this.cachedBlockGetter != null && this.cachedBlockGetterPos == k) {
            return this.cachedBlockGetter;
        }
        this.cachedBlockGetter = blockView = this.collisionGetter.getChunkForCollisions(i, j);
        this.cachedBlockGetterPos = k;
        return blockView;
    }

    protected VoxelShape computeNext() {
        while (this.cursor.advance()) {
            ICustomCollisions customCollisions;
            Entity entity;
            BlockGetter blockgetter;
            int i = this.cursor.nextX();
            int j = this.cursor.nextY();
            int k = this.cursor.nextZ();
            int l = this.cursor.getNextType();
            if (l == 3 || (blockgetter = this.getChunk(i, k)) == null) continue;
            this.pos.set(i, j, k);
            BlockState blockstate = blockgetter.getBlockState((BlockPos)this.pos);
            if (this.onlySuffocatingBlocks && !blockstate.isSuffocating(blockgetter, (BlockPos)this.pos) || l == 1 && !blockstate.hasLargeCollisionShape() || l == 2 && !blockstate.is(Blocks.MOVING_PISTON)) continue;
            VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)this.collisionGetter, (BlockPos)this.pos, this.context);
            if (this.context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)this.context).getEntity()) instanceof ICustomCollisions && (customCollisions = (ICustomCollisions)entity).canPassThrough((BlockPos)this.pos, blockstate, voxelshape)) continue;
            if (voxelshape == Shapes.block()) {
                if (!this.box.intersects((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0)) continue;
                return voxelshape.move((double)i, (double)j, (double)k);
            }
            VoxelShape voxelshape1 = voxelshape.move((double)i, (double)j, (double)k);
            if (!Shapes.joinIsNotEmpty((VoxelShape)voxelshape1, (VoxelShape)this.entityShape, (BooleanOp)BooleanOp.AND)) continue;
            return voxelshape1;
        }
        return (VoxelShape)this.endOfData();
    }
}

