/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridInsertionHint;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.grid.energy.EnergyGridInsertionHint;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerScreen;
import com.ultramega.refinedtypes.registry.Items;
import com.ultramega.refinedtypes.registry.Menus;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.energy.EnergyResourceRendering;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.soul.SoulResourceRendering;
import com.ultramega.refinedtypes.type.source.SourceResource;
import com.ultramega.refinedtypes.type.source.SourceResourceRendering;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public final class ClientModInitializer {
    private ClientModInitializer() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        RefinedStorageClientApi.INSTANCE.registerResourceRendering(EnergyResource.class, (ResourceRendering)new EnergyResourceRendering());
        RefinedStorageClientApi.INSTANCE.addAlternativeGridInsertionHint((GridInsertionHint)new EnergyGridInsertionHint());
        ResourceLocation energyDiskModel = RefinedTypesUtil.createRefinedTypesIdentifier("block/disk/energy_disk");
        for (EnergyStorageVariant variant : EnergyStorageVariant.values()) {
            RefinedStorageClientApi.INSTANCE.registerDiskModel(Items.getEnergyStorageDisk(variant), energyDiskModel);
        }
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            RefinedStorageClientApi.INSTANCE.registerResourceRendering(SourceResource.class, (ResourceRendering)new SourceResourceRendering(Platform.INSTANCE.getBucketAmount()));
            ResourceLocation sourceDiskModel = RefinedTypesUtil.createRefinedTypesIdentifier("block/disk/source_disk");
            for (SourceStorageVariant sourceStorageVariant : SourceStorageVariant.values()) {
                RefinedStorageClientApi.INSTANCE.registerDiskModel(Items.getSourceStorageDisk(sourceStorageVariant), sourceDiskModel);
            }
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            RefinedStorageClientApi.INSTANCE.registerResourceRendering(SoulResource.class, (ResourceRendering)new SoulResourceRendering());
            ResourceLocation soulDiskModel = RefinedTypesUtil.createRefinedTypesIdentifier("block/disk/soul_disk");
            for (SoulStorageVariant soulStorageVariant : SoulStorageVariant.values()) {
                RefinedStorageClientApi.INSTANCE.registerDiskModel(Items.getSoulStorageDisk(soulStorageVariant), soulDiskModel);
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent e) {
        e.register(Menus.getNetworkEnergizer(), NetworkEnergizerScreen::new);
        e.register(Menus.getEnergyStorage(), (menu, inventory, title) -> RefinedStorageClientApi.INSTANCE.createStorageBlockScreen(menu, inventory, title, EnergyResource.class));
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            e.register(Menus.getSourceStorage(), (menu, inventory, title) -> RefinedStorageClientApi.INSTANCE.createStorageBlockScreen(menu, inventory, title, SourceResource.class));
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            e.register(Menus.getSoulStorage(), (menu, inventory, title) -> RefinedStorageClientApi.INSTANCE.createStorageBlockScreen(menu, inventory, title, SoulResource.class));
        }
    }
}

