/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes;

import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.storage.externalstorage.ExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.storage.StorageContainerUpgradeRecipe;
import com.refinedmods.refinedstorage.common.storage.StorageContainerUpgradeRecipeSerializer;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.support.SimpleItem;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.ultramega.refinedtypes.ClientModInitializer;
import com.ultramega.refinedtypes.Config;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.autocrafting.EnergyPatternProviderExternalPatternSinkFactory;
import com.ultramega.refinedtypes.autocrafting.SoulPatternProviderExternalPatternSinkFactory;
import com.ultramega.refinedtypes.autocrafting.SourcePatternProviderExternalPatternSinkFactory;
import com.ultramega.refinedtypes.compat.emi.EmiEnergyResourceModIngredientConverter;
import com.ultramega.refinedtypes.compat.jei.JEIRecipeModIngredientConverter;
import com.ultramega.refinedtypes.exporter.EnergyExporterTransferStrategyFactory;
import com.ultramega.refinedtypes.exporter.SoulExporterTransferStrategyFactory;
import com.ultramega.refinedtypes.exporter.SourceExporterTransferStrategyFactory;
import com.ultramega.refinedtypes.externalstorage.EnergyPlatformExternalStorageProviderFactory;
import com.ultramega.refinedtypes.externalstorage.SoulPlatformExternalStorageProviderFactory;
import com.ultramega.refinedtypes.externalstorage.SourcePlatformExternalStorageProviderFactory;
import com.ultramega.refinedtypes.grid.TypeGridResourceFactory;
import com.ultramega.refinedtypes.grid.energy.EnergyGridExtractionStrategy;
import com.ultramega.refinedtypes.grid.energy.EnergyGridInsertionStrategy;
import com.ultramega.refinedtypes.importer.EnergyImporterTransferStrategyFactory;
import com.ultramega.refinedtypes.importer.SoulImporterTransferStrategyFactory;
import com.ultramega.refinedtypes.importer.SourceImporterTransferStrategyFactory;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerBlock;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerBlockEntity;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerContainerMenu;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerData;
import com.ultramega.refinedtypes.packet.s2c.NetworkEnergizerEnergyInfoPacket;
import com.ultramega.refinedtypes.registry.BlockEntities;
import com.ultramega.refinedtypes.registry.Blocks;
import com.ultramega.refinedtypes.registry.Items;
import com.ultramega.refinedtypes.registry.Menus;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageBlockBlockItem;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageBlockProvider;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageDiskItem;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.energy.ResourceContainerEnergyHandlerAdapter;
import com.ultramega.refinedtypes.storage.soul.SoulStorageBlockBlockItem;
import com.ultramega.refinedtypes.storage.soul.SoulStorageBlockProvider;
import com.ultramega.refinedtypes.storage.soul.SoulStorageDiskItem;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageBlockBlockItem;
import com.ultramega.refinedtypes.storage.source.SourceStorageBlockProvider;
import com.ultramega.refinedtypes.storage.source.SourceStorageDiskItem;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import com.ultramega.refinedtypes.storagemonitor.EnergyStorageMonitorInsertionStrategy;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.energy.EnergyResourceContainerInsertStrategy;
import com.ultramega.refinedtypes.type.energy.EnergyResourceFactory;
import com.ultramega.refinedtypes.type.energy.EnergyResourceType;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.soul.SoulResourceFactory;
import com.ultramega.refinedtypes.type.soul.SoulResourceType;
import com.ultramega.refinedtypes.type.soul.SoulUtil;
import com.ultramega.refinedtypes.type.source.SourceResource;
import com.ultramega.refinedtypes.type.source.SourceResourceFactory;
import com.ultramega.refinedtypes.type.source.SourceResourceType;
import com.ultramega.refinedtypes.type.source.SourceUtil;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="refinedtypes")
public final class ModInitializer {
    private static final ResourceLocation ENERGY_ID = RefinedTypesUtil.createRefinedTypesIdentifier("energy");
    private static final ResourceLocation SOURCE_ID = RefinedTypesUtil.createRefinedTypesIdentifier("source");
    private static final ResourceLocation SOUL_ID = RefinedTypesUtil.createRefinedTypesIdentifier("soul");
    private static final Config CONFIG = new Config();

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG.getSpec());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerRegistries);
        eventBus.addListener(this::registerCreativeModeTab);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::registerPackets);
        Types.TYPES.register(eventBus);
        DeferredRegister itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"refinedtypes");
        ModInitializer.registerItems((DeferredRegister<Item>)itemRegistry);
        itemRegistry.register(eventBus);
        DeferredRegister blockRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"refinedtypes");
        ModInitializer.registerBlocks((DeferredRegister<Block>)blockRegistry);
        blockRegistry.register(eventBus);
        DeferredRegister blockEntityRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"refinedtypes");
        ModInitializer.registerBlockEntities(blockEntityRegistry);
        blockEntityRegistry.register(eventBus);
        DeferredRegister menuRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"refinedtypes");
        ExtendedMenuTypeFactory extendedMenuTypeFactory = new ExtendedMenuTypeFactory(this){

            public <T extends AbstractContainerMenu, D> MenuType<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
                return IMenuTypeExtension.create((syncId, inventory, buf) -> {
                    Object data = streamCodec.decode((Object)buf);
                    return supplier.create(syncId, inventory, data);
                });
            }
        };
        ModInitializer.registerMenus(menuRegistry, extendedMenuTypeFactory);
        menuRegistry.register(eventBus);
        DeferredRegister recipeSerializerRegistry = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"refinedtypes");
        ModInitializer.registerRecipeSerializers(recipeSerializerRegistry);
        recipeSerializerRegistry.register(eventBus);
    }

    private static void registerBlocks(DeferredRegister<Block> registry) {
        Blocks.setNetworkEnergizer((Supplier<NetworkEnergizerBlock>)registry.register("network_energizer", NetworkEnergizerBlock::new));
        for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
            Blocks.setEnergyStorageBlock(energyStorageVariant, (Supplier<Block>)registry.register(energyStorageVariant.getStorageBlockId().getPath(), () -> RefinedStorageApi.INSTANCE.createStorageBlock(BlockConstants.PROPERTIES, (StorageBlockProvider)new EnergyStorageBlockProvider(energyStorageVariant))));
        }
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            for (Enum enum_ : SourceStorageVariant.values()) {
                Blocks.setSourceStorageBlock((SourceStorageVariant)enum_, (Supplier<Block>)registry.register(((SourceStorageVariant)enum_).getStorageBlockId().getPath(), () -> ModInitializer.lambda$registerBlocks$1((SourceStorageVariant)enum_)));
            }
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            for (Enum enum_ : SoulStorageVariant.values()) {
                Blocks.setSoulStorageBlock((SoulStorageVariant)enum_, (Supplier<Block>)registry.register(((SoulStorageVariant)enum_).getStorageBlockId().getPath(), () -> ModInitializer.lambda$registerBlocks$2((SoulStorageVariant)enum_)));
            }
        }
    }

    private static void registerItems(DeferredRegister<Item> registry) {
        registry.register("network_energizer", () -> Blocks.getNetworkEnergizer().createBlockItem());
        for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
            Items.setEnergyStoragePart(energyStorageVariant, (Supplier<Item>)registry.register(energyStorageVariant.getStoragePartId().getPath(), SimpleItem::new));
            Items.setEnergyStorageDisk(energyStorageVariant, (Supplier<Item>)registry.register(energyStorageVariant.getStorageDiskId().getPath(), () -> new EnergyStorageDiskItem(RefinedStorageApi.INSTANCE.getStorageContainerItemHelper(), energyStorageVariant)));
            Items.setEnergyStorageBlock(energyStorageVariant, (Supplier<Item>)registry.register(energyStorageVariant.getStorageBlockId().getPath(), () -> new EnergyStorageBlockBlockItem(Blocks.getEnergyStorageBlock(energyStorageVariant), energyStorageVariant)));
        }
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            for (Enum enum_ : SourceStorageVariant.values()) {
                Items.setSourceStoragePart((SourceStorageVariant)enum_, (Supplier<Item>)registry.register(((SourceStorageVariant)enum_).getStoragePartId().getPath(), SimpleItem::new));
                Items.setSourceStorageDisk((SourceStorageVariant)enum_, (Supplier<Item>)registry.register(((SourceStorageVariant)enum_).getStorageDiskId().getPath(), () -> ModInitializer.lambda$registerItems$6((SourceStorageVariant)enum_)));
                Items.setSourceStorageBlock((SourceStorageVariant)enum_, (Supplier<Item>)registry.register(((SourceStorageVariant)enum_).getStorageBlockId().getPath(), () -> ModInitializer.lambda$registerItems$7((SourceStorageVariant)enum_)));
            }
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            for (Enum enum_ : SoulStorageVariant.values()) {
                Items.setSoulStoragePart((SoulStorageVariant)enum_, (Supplier<Item>)registry.register(((SoulStorageVariant)enum_).getStoragePartId().getPath(), SimpleItem::new));
                Items.setSoulStorageDisk((SoulStorageVariant)enum_, (Supplier<Item>)registry.register(((SoulStorageVariant)enum_).getStorageDiskId().getPath(), () -> ModInitializer.lambda$registerItems$8((SoulStorageVariant)enum_)));
                Items.setSoulStorageBlock((SoulStorageVariant)enum_, (Supplier<Item>)registry.register(((SoulStorageVariant)enum_).getStorageBlockId().getPath(), () -> ModInitializer.lambda$registerItems$9((SoulStorageVariant)enum_)));
            }
        }
    }

    private static void registerBlockEntities(DeferredRegister<BlockEntityType<?>> registry) {
        BlockEntities.setNetworkEnergizer((Supplier<BlockEntityType<NetworkEnergizerBlockEntity>>)registry.register("network_energizer", () -> new BlockEntityType(NetworkEnergizerBlockEntity::new, Set.of(Blocks.getNetworkEnergizer()), null)));
        for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
            BlockEntities.setEnergyStorageBlock(energyStorageVariant, registry.register(energyStorageVariant.getStorageBlockId().getPath(), () -> new BlockEntityType((pos, state) -> RefinedStorageApi.INSTANCE.createStorageBlockEntity(pos, state, (StorageBlockProvider)new EnergyStorageBlockProvider(energyStorageVariant)), Set.of(Blocks.getEnergyStorageBlock(energyStorageVariant)), null)));
        }
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            for (Enum enum_ : SourceStorageVariant.values()) {
                BlockEntities.setSourceStorageBlock((SourceStorageVariant)enum_, registry.register(((SourceStorageVariant)enum_).getStorageBlockId().getPath(), () -> ModInitializer.lambda$registerBlockEntities$14((SourceStorageVariant)enum_)));
            }
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            for (Enum enum_ : SoulStorageVariant.values()) {
                BlockEntities.setSoulStorageBlock((SoulStorageVariant)enum_, registry.register(((SoulStorageVariant)enum_).getStorageBlockId().getPath(), () -> ModInitializer.lambda$registerBlockEntities$16((SoulStorageVariant)enum_)));
            }
        }
    }

    private static void registerMenus(DeferredRegister<MenuType<?>> registry, ExtendedMenuTypeFactory extendedMenuTypeFactory) {
        Menus.setNetworkEnergizer((Supplier<MenuType<NetworkEnergizerContainerMenu>>)registry.register("network_energizer", () -> extendedMenuTypeFactory.create(NetworkEnergizerContainerMenu::new, NetworkEnergizerData.STREAM_CODEC)));
        Menus.setEnergyStorage((Supplier<MenuType<AbstractContainerMenu>>)registry.register("energy_storage_block", () -> extendedMenuTypeFactory.create((syncId, playerInventory, data) -> RefinedStorageApi.INSTANCE.createStorageBlockContainerMenu(syncId, playerInventory.player, data, (ResourceFactory)EnergyResourceFactory.INSTANCE, Menus.getEnergyStorage()), RefinedStorageApi.INSTANCE.getStorageBlockDataStreamCodec())));
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            Menus.setSourceStorage((Supplier<MenuType<AbstractContainerMenu>>)registry.register("source_storage_block", () -> extendedMenuTypeFactory.create((syncId, playerInventory, data) -> RefinedStorageApi.INSTANCE.createStorageBlockContainerMenu(syncId, playerInventory.player, data, (ResourceFactory)SourceResourceFactory.INSTANCE, Menus.getSourceStorage()), RefinedStorageApi.INSTANCE.getStorageBlockDataStreamCodec())));
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            Menus.setSoulStorage((Supplier<MenuType<AbstractContainerMenu>>)registry.register("soul_storage_block", () -> extendedMenuTypeFactory.create((syncId, playerInventory, data) -> RefinedStorageApi.INSTANCE.createStorageBlockContainerMenu(syncId, playerInventory.player, data, (ResourceFactory)SoulResourceFactory.INSTANCE, Menus.getSoulStorage()), RefinedStorageApi.INSTANCE.getStorageBlockDataStreamCodec())));
        }
    }

    private static void registerRecipeSerializers(DeferredRegister<RecipeSerializer<?>> registry) {
        registry.register("energy_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])EnergyStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])EnergyStorageVariant.values(), (StorageVariant)to, Items::getEnergyStorageDisk)));
        registry.register("energy_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])EnergyStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])EnergyStorageVariant.values(), (StorageVariant)to, Items::getEnergyStorageBlock)));
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            registry.register("source_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])SourceStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])SourceStorageVariant.values(), (StorageVariant)to, Items::getSourceStorageDisk)));
            registry.register("source_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])SourceStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])SourceStorageVariant.values(), (StorageVariant)to, Items::getSourceStorageBlock)));
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            registry.register("soul_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])SoulStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])SoulStorageVariant.values(), (StorageVariant)to, Items::getSoulStorageDisk)));
            registry.register("soul_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])SoulStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])SoulStorageVariant.values(), (StorageVariant)to, Items::getSoulStorageBlock)));
        }
    }

    private void setup(FMLCommonSetupEvent e) {
        RefinedStorageApi.INSTANCE.getResourceTypeRegistry().register(ENERGY_ID, (Object)EnergyResourceType.INSTANCE);
        RefinedStorageApi.INSTANCE.getAlternativeResourceFactories().add(EnergyResourceFactory.INSTANCE);
        RefinedStorageApi.INSTANCE.getStorageTypeRegistry().register(ENERGY_ID, (Object)EnergyResourceType.STORAGE_TYPE);
        RefinedStorageApi.INSTANCE.addGridResourceRepositoryMapper(EnergyResource.class, (ResourceRepositoryMapper)new TypeGridResourceFactory());
        RefinedStorageApi.INSTANCE.addGridInsertionStrategyFactory(EnergyGridInsertionStrategy::new);
        RefinedStorageApi.INSTANCE.addGridExtractionStrategyFactory(EnergyGridExtractionStrategy::new);
        RefinedStorageApi.INSTANCE.addStorageMonitorInsertionStrategy((StorageMonitorInsertionStrategy)new EnergyStorageMonitorInsertionStrategy());
        RefinedStorageApi.INSTANCE.addResourceContainerInsertStrategy((ResourceContainerInsertStrategy)new EnergyResourceContainerInsertStrategy());
        RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().register(ENERGY_ID, (Object)new EnergyImporterTransferStrategyFactory());
        RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().register(ENERGY_ID, (Object)new EnergyExporterTransferStrategyFactory());
        RefinedStorageApi.INSTANCE.addExternalStorageProviderFactory((ExternalStorageProviderFactory)new EnergyPlatformExternalStorageProviderFactory());
        RefinedStorageApi.INSTANCE.addPatternProviderExternalPatternSinkFactory((PatternProviderExternalPatternSinkFactory)new EnergyPatternProviderExternalPatternSinkFactory());
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            RefinedStorageApi.INSTANCE.getResourceTypeRegistry().register(SOURCE_ID, (Object)SourceResourceType.INSTANCE);
            RefinedStorageApi.INSTANCE.getAlternativeResourceFactories().add(SourceResourceFactory.INSTANCE);
            RefinedStorageApi.INSTANCE.getStorageTypeRegistry().register(SOURCE_ID, (Object)SourceResourceType.STORAGE_TYPE);
            RefinedStorageApi.INSTANCE.addGridResourceRepositoryMapper(SourceResource.class, (ResourceRepositoryMapper)new TypeGridResourceFactory());
            RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().register(SOURCE_ID, (Object)new SourceImporterTransferStrategyFactory());
            RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().register(SOURCE_ID, (Object)new SourceExporterTransferStrategyFactory());
            RefinedStorageApi.INSTANCE.addExternalStorageProviderFactory((ExternalStorageProviderFactory)new SourcePlatformExternalStorageProviderFactory());
            RefinedStorageApi.INSTANCE.addPatternProviderExternalPatternSinkFactory((PatternProviderExternalPatternSinkFactory)new SourcePatternProviderExternalPatternSinkFactory());
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            RefinedStorageApi.INSTANCE.getResourceTypeRegistry().register(SOUL_ID, (Object)SoulResourceType.INSTANCE);
            RefinedStorageApi.INSTANCE.getAlternativeResourceFactories().add(SoulResourceFactory.INSTANCE);
            RefinedStorageApi.INSTANCE.getStorageTypeRegistry().register(SOUL_ID, (Object)SoulResourceType.STORAGE_TYPE);
            RefinedStorageApi.INSTANCE.addGridResourceRepositoryMapper(SoulResource.class, (ResourceRepositoryMapper)new TypeGridResourceFactory());
            RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().register(SOUL_ID, (Object)new SoulImporterTransferStrategyFactory());
            RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().register(SOUL_ID, (Object)new SoulExporterTransferStrategyFactory());
            RefinedStorageApi.INSTANCE.addExternalStorageProviderFactory((ExternalStorageProviderFactory)new SoulPlatformExternalStorageProviderFactory());
            RefinedStorageApi.INSTANCE.addPatternProviderExternalPatternSinkFactory((PatternProviderExternalPatternSinkFactory)new SoulPatternProviderExternalPatternSinkFactory());
        }
        if (ModList.get().isLoaded("emi")) {
            RefinedStorageApi.INSTANCE.addIngredientConverter((RecipeModIngredientConverter)new EmiEnergyResourceModIngredientConverter());
        } else if (ModList.get().isLoaded("jei")) {
            RefinedStorageApi.INSTANCE.addIngredientConverter((RecipeModIngredientConverter)new JEIRecipeModIngredientConverter());
        }
    }

    private void registerRegistries(NewRegistryEvent event) {
        event.register(Types.TYPE_REGISTRY);
    }

    private void registerCreativeModeTab(RegisterEvent e) {
        e.register(Registries.CREATIVE_MODE_TAB, helper -> helper.register(RefinedTypesUtil.CREATIVE_MODE_TAB, (Object)CreativeModeTab.builder().title((Component)RefinedTypesUtil.MOD).icon(() -> Items.getEnergyStoragePart(EnergyStorageVariant.K_64).getDefaultInstance()).displayItems((params, output) -> {
            output.accept((ItemLike)Blocks.getNetworkEnergizer());
            for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
                output.accept((ItemLike)Items.getEnergyStoragePart(energyStorageVariant));
            }
            for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
                output.accept((ItemLike)Items.getEnergyStorageDisk(energyStorageVariant));
            }
            for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
                output.accept((ItemLike)Items.getEnergyStorageBlock(energyStorageVariant));
            }
            if (RefinedTypesUtil.isArsNouveauLoaded()) {
                for (Enum enum_ : SourceStorageVariant.values()) {
                    output.accept((ItemLike)Items.getSourceStoragePart((SourceStorageVariant)enum_));
                }
                for (Enum enum_ : SourceStorageVariant.values()) {
                    output.accept((ItemLike)Items.getSourceStorageDisk((SourceStorageVariant)enum_));
                }
                for (Enum enum_ : SourceStorageVariant.values()) {
                    output.accept((ItemLike)Items.getSourceStorageBlock((SourceStorageVariant)enum_));
                }
            }
            if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
                for (Enum enum_ : SoulStorageVariant.values()) {
                    output.accept((ItemLike)Items.getSoulStoragePart((SoulStorageVariant)enum_));
                }
                for (Enum enum_ : SoulStorageVariant.values()) {
                    output.accept((ItemLike)Items.getSoulStorageDisk((SoulStorageVariant)enum_));
                }
                for (Enum enum_ : SoulStorageVariant.values()) {
                    output.accept((ItemLike)Items.getSoulStorageBlock((SoulStorageVariant)enum_));
                }
            }
        }).build()));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerNetworkNodeContainerProvider(event, BlockEntities.getNetworkEnergizer());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, com.refinedmods.refinedstorage.common.content.BlockEntities.INSTANCE.getInterface(), (be, side) -> new ResourceContainerEnergyHandlerAdapter((ResourceContainer)be.getExportedResources()));
        for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
            this.registerNetworkNodeContainerProvider(event, BlockEntities.getEnergyStorageBlock(energyStorageVariant));
        }
        if (RefinedTypesUtil.isArsNouveauLoaded()) {
            SourceUtil.registerCapability(event);
            for (Enum enum_ : SourceStorageVariant.values()) {
                this.registerNetworkNodeContainerProvider(event, BlockEntities.getSourceStorageBlock((SourceStorageVariant)enum_));
            }
        }
        if (RefinedTypesUtil.isIndustrialForegoingSoulsLoaded()) {
            SoulUtil.registerCapability(event);
            for (Enum enum_ : SoulStorageVariant.values()) {
                this.registerNetworkNodeContainerProvider(event, BlockEntities.getSoulStorageBlock((SoulStorageVariant)enum_));
            }
        }
    }

    private void registerNetworkNodeContainerProvider(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), type, (be, side) -> be.getContainerProvider());
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("refinedtypes");
        ModInitializer.registerServerToClientPackets(registrar);
    }

    private static void registerServerToClientPackets(PayloadRegistrar registrar) {
        registrar.playToClient(NetworkEnergizerEnergyInfoPacket.PACKET_TYPE, NetworkEnergizerEnergyInfoPacket.STREAM_CODEC, ModInitializer.wrapHandler(NetworkEnergizerEnergyInfoPacket::handle));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((IPayloadContext)ctx).player());
    }

    public static Config getConfig() {
        return CONFIG;
    }

    private static /* synthetic */ BlockEntityType lambda$registerBlockEntities$16(SoulStorageVariant variant) {
        return new BlockEntityType((pos, state) -> RefinedStorageApi.INSTANCE.createStorageBlockEntity(pos, state, (StorageBlockProvider)new SoulStorageBlockProvider(variant)), Set.of(Blocks.getSoulStorageBlock(variant)), null);
    }

    private static /* synthetic */ BlockEntityType lambda$registerBlockEntities$14(SourceStorageVariant variant) {
        return new BlockEntityType((pos, state) -> RefinedStorageApi.INSTANCE.createStorageBlockEntity(pos, state, (StorageBlockProvider)new SourceStorageBlockProvider(variant)), Set.of(Blocks.getSourceStorageBlock(variant)), null);
    }

    private static /* synthetic */ Item lambda$registerItems$9(SoulStorageVariant variant) {
        return new SoulStorageBlockBlockItem(Blocks.getSoulStorageBlock(variant), variant);
    }

    private static /* synthetic */ Item lambda$registerItems$8(SoulStorageVariant variant) {
        return new SoulStorageDiskItem(RefinedStorageApi.INSTANCE.getStorageContainerItemHelper(), variant);
    }

    private static /* synthetic */ Item lambda$registerItems$7(SourceStorageVariant variant) {
        return new SourceStorageBlockBlockItem(Blocks.getSourceStorageBlock(variant), variant);
    }

    private static /* synthetic */ Item lambda$registerItems$6(SourceStorageVariant variant) {
        return new SourceStorageDiskItem(RefinedStorageApi.INSTANCE.getStorageContainerItemHelper(), variant);
    }

    private static /* synthetic */ Block lambda$registerBlocks$2(SoulStorageVariant variant) {
        return RefinedStorageApi.INSTANCE.createStorageBlock(BlockConstants.PROPERTIES, (StorageBlockProvider)new SoulStorageBlockProvider(variant));
    }

    private static /* synthetic */ Block lambda$registerBlocks$1(SourceStorageVariant variant) {
        return RefinedStorageApi.INSTANCE.createStorageBlock(BlockConstants.PROPERTIES, (StorageBlockProvider)new SourceStorageBlockProvider(variant));
    }
}

