/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.ultramega.refinedtypes.type.Type;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public final class TypeRenderer {
    private TypeRenderer() {
    }

    public static void render(PoseStack poseStack, int x, int y, Type type) {
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation icon = type.icon();
        TextureAtlasSprite sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(icon);
        TypeRenderer.render(poseStack, x, y, sprite);
    }

    public static void render(PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, Type type) {
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation icon = type.icon();
        TextureAtlasSprite sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(icon);
        TypeRenderer.render(poseStack, renderTypeBuffer, light, sprite);
    }

    private static void render(PoseStack poseStack, int x, int y, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        int slotXEnd = x + 16;
        int slotYEnd = y + 16;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)x, (float)slotYEnd, 0.0f).setUv(sprite.getU0(), sprite.getV1()).setColor(255, 255, 255, 255);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)slotXEnd, (float)slotYEnd, 0.0f).setUv(sprite.getU1(), sprite.getV1()).setColor(255, 255, 255, 255);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)slotXEnd, (float)y, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(255, 255, 255, 255);
        bufferBuilder.addVertex(poseStack.last().pose(), (float)x, (float)y, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(255, 255, 255, 255);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void render(PoseStack poseStack, MultiBufferSource buffers, int light, TextureAtlasSprite sprite) {
        VertexConsumer buffer = buffers.getBuffer(RenderType.solid());
        float scale = 0.3f;
        float x0 = -0.15f;
        float y0 = 0.15f;
        float x1 = 0.15f;
        float y1 = -0.15f;
        Matrix4f transform = poseStack.last().pose();
        buffer.addVertex(transform, -0.15f, -0.15f, 0.0f).setColor(0xFFFFFF).setUv(sprite.getU0(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, 0.15f, -0.15f, 0.0f).setColor(0xFFFFFF).setUv(sprite.getU1(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, 0.15f, 0.15f, 0.0f).setColor(0xFFFFFF).setUv(sprite.getU1(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, -0.15f, 0.15f, 0.0f).setColor(0xFFFFFF).setUv(sprite.getU0(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
    }
}

