/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen.tag;

import com.refinedmods.refinedstorage.neoforge.datagen.tag.BlockTagsProvider;
import com.ultramega.refinedtypes.registry.Blocks;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTagsProviderImpl
extends TagsProvider<Block> {
    public BlockTagsProviderImpl(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> providerCompletableFuture, ExistingFileHelper existingFileHelper) {
        super(packOutput, Registries.BLOCK, providerCompletableFuture, "refinedtypes", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.markAsMineable((Block)Blocks.getNetworkEnergizer(), true);
        for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
            this.markAsMineable(Blocks.getEnergyStorageBlock(energyStorageVariant), false);
        }
        for (Enum enum_ : SourceStorageVariant.values()) {
            this.markAsMineable(Blocks.getSourceStorageBlock((SourceStorageVariant)enum_), true);
        }
        for (Enum enum_ : SoulStorageVariant.values()) {
            this.markAsMineable(Blocks.getSoulStorageBlock((SoulStorageVariant)enum_), true);
        }
    }

    private void markAsMineable(Block block, boolean optional) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (optional) {
            this.tag(BlockTagsProvider.MINEABLE).addOptional(key);
        } else {
            this.tag(BlockTagsProvider.MINEABLE).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key));
        }
    }
}

