/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen.tag;

import com.ultramega.refinedtypes.registry.Items;
import com.ultramega.refinedtypes.registry.Tags;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagsProviderImpl
extends ItemTagsProvider {
    public ItemTagsProviderImpl(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, TagsProvider<Block> blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, blockTagsProvider.contentsGetter(), "refinedtypes", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.addAllToTag(Tags.ENERGY_STORAGE_DISKS, Arrays.stream(EnergyStorageVariant.values()).map(Items::getEnergyStorageDisk).map(t -> () -> t).toList(), false);
        this.addAllToTag(Tags.SOURCE_STORAGE_DISKS, Arrays.stream(SourceStorageVariant.values()).map(Items::getSourceStorageDisk).map(t -> () -> t).toList(), true);
        this.addAllToTag(Tags.SOUL_STORAGE_DISKS, Arrays.stream(SoulStorageVariant.values()).map(Items::getSoulStorageDisk).map(t -> () -> t).toList(), true);
    }

    private <T extends Item> void addAllToTag(TagKey<Item> tag, Collection<Supplier<T>> items, boolean optional) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender builder = this.tag(tag);
        for (Supplier<T> supplier : items) {
            Item item = (Item)supplier.get();
            if (optional) {
                builder.addOptional(BuiltInRegistries.ITEM.getKey((Object)item));
                continue;
            }
            builder.add((Object)item);
        }
        builder.replace(false);
    }
}

