/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.registry;

import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerBlockEntity;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class BlockEntities {
    private static final Map<EnergyStorageVariant, Supplier<BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>>>> ENERGY_STORAGE_BLOCKS = new EnumMap(EnergyStorageVariant.class);
    private static final Map<SourceStorageVariant, Supplier<BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>>>> SOURCE_STORAGE_BLOCKS = new EnumMap(SourceStorageVariant.class);
    private static final Map<SoulStorageVariant, Supplier<BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>>>> SOUL_STORAGE_BLOCKS = new EnumMap(SoulStorageVariant.class);
    @Nullable
    private static Supplier<BlockEntityType<NetworkEnergizerBlockEntity>> networkEnergizer;

    private BlockEntities() {
    }

    public static BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>> getEnergyStorageBlock(EnergyStorageVariant variant) {
        return ENERGY_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setEnergyStorageBlock(EnergyStorageVariant variant, Supplier<BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>>> supplier) {
        ENERGY_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>> getSourceStorageBlock(SourceStorageVariant variant) {
        return SOURCE_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setSourceStorageBlock(SourceStorageVariant variant, Supplier<BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>>> supplier) {
        SOURCE_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>> getSoulStorageBlock(SoulStorageVariant variant) {
        return SOUL_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setSoulStorageBlock(SoulStorageVariant variant, Supplier<BlockEntityType<AbstractNetworkNodeContainerBlockEntity<?>>> supplier) {
        SOUL_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static BlockEntityType<NetworkEnergizerBlockEntity> getNetworkEnergizer() {
        return Objects.requireNonNull(networkEnergizer).get();
    }

    public static void setNetworkEnergizer(Supplier<BlockEntityType<NetworkEnergizerBlockEntity>> supplier) {
        networkEnergizer = supplier;
    }
}

