/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.energy;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.energy.EnergyResourceType;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.world.item.ItemStack;

public class ResourceContainerEnergyHandlerAdapter
implements ILongEnergyStorage {
    private final ResourceContainer container;

    public ResourceContainerEnergyHandlerAdapter(ResourceContainer container) {
        this.container = container;
    }

    public long receive(long maxReceive, boolean simulate) {
        if (maxReceive <= 0L) {
            return 0L;
        }
        for (int i = 0; i < this.container.size(); ++i) {
            long received;
            ResourceAmount currentResource = this.container.get(i);
            if (currentResource == null) {
                return this.insertEnergyInEmptySlot(i, maxReceive, simulate);
            }
            if (!(currentResource.resource() instanceof EnergyResource) || (received = this.insertEnergyInFilledSlot(i, maxReceive, simulate, currentResource)) <= 0L) continue;
            return received;
        }
        return 0L;
    }

    private long insertEnergyInFilledSlot(int index, long maxReceive, boolean simulate, ResourceAmount currentResource) {
        long currentAmount = currentResource.amount();
        long toInsert = Math.min(maxReceive, Math.max(this.container.getMaxAmount(currentResource.resource()), EnergyResourceType.INSTANCE.getInterfaceExportLimit()) - currentAmount);
        if (toInsert <= 0L) {
            return 0L;
        }
        if (!simulate) {
            this.container.set(index, new ResourceAmount(currentResource.resource(), currentAmount + toInsert));
        }
        return toInsert;
    }

    private long insertEnergyInEmptySlot(int tank, long maxReceive, boolean simulate) {
        long toInsert = Math.min(maxReceive, Math.max(this.container.getMaxAmount((ResourceKey)ItemResource.ofItemStack((ItemStack)ItemStack.EMPTY)), EnergyResourceType.INSTANCE.getInterfaceExportLimit()));
        if (!simulate) {
            this.container.set(tank, new ResourceAmount((ResourceKey)EnergyResource.createEnergyResource(), toInsert));
        }
        return toInsert;
    }

    public long extract(long maxExtract, boolean simulate) {
        if (maxExtract <= 0L) {
            return 0L;
        }
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resourceAmount = this.container.get(i);
            if (resourceAmount == null || !(resourceAmount.resource() instanceof EnergyResource)) continue;
            long available = resourceAmount.amount();
            if (available <= 0L) {
                return 0L;
            }
            long toExtract = Math.min(maxExtract, available);
            if (!simulate) {
                this.container.shrink(i, toExtract);
            }
            return toExtract;
        }
        return 0L;
    }

    public long getAmount() {
        long amount = 0L;
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resourceAmount = this.container.get(i);
            if (resourceAmount == null || !(resourceAmount.resource() instanceof EnergyResource)) continue;
            amount += resourceAmount.amount();
        }
        return amount;
    }

    public long getCapacity() {
        long capacity = 0L;
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resource = this.container.get(i);
            if (resource != null && !(resource.resource() instanceof EnergyResource)) continue;
            capacity += Math.max(this.container.getMaxAmount((ResourceKey)(resource != null ? resource.resource() : ItemResource.ofItemStack((ItemStack)ItemStack.EMPTY))), EnergyResourceType.INSTANCE.getInterfaceExportLimit());
        }
        return capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

