/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.energy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.TypeRenderer;
import com.ultramega.refinedtypes.type.Type;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class EnergyResourceRendering
implements ResourceRendering {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));

    public String formatAmount(long amount, boolean withUnits) {
        return !withUnits ? EnergyResourceRendering.format(amount) : IdentifierUtil.formatWithUnits((double)amount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getDisplayName(ResourceKey resourceKey) {
        if (!(resourceKey instanceof EnergyResource)) return Component.empty();
        EnergyResource energyResource = (EnergyResource)resourceKey;
        try {
            Type type;
            Type type2 = type = energyResource.type();
            return type2.getDisplayName();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Component> getTooltip(ResourceKey resourceKey) {
        Type type2;
        if (!(resourceKey instanceof EnergyResource)) return Collections.emptyList();
        EnergyResource energyResource = (EnergyResource)resourceKey;
        try {
            Type type;
            type2 = type = energyResource.type();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return List.of(type2.getDisplayName());
    }

    public void render(ResourceKey resourceKey, GuiGraphics graphics, int x, int y) {
        if (resourceKey instanceof EnergyResource) {
            Type type;
            EnergyResource energyResource = (EnergyResource)resourceKey;
            try {
                Type type2;
                type = type2 = energyResource.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            TypeRenderer.render(graphics.pose(), x, y, type);
        }
    }

    public void render(ResourceKey resourceKey, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, Level level) {
        if (resourceKey instanceof EnergyResource) {
            Type type;
            EnergyResource energyResource = (EnergyResource)resourceKey;
            try {
                Type type2;
                type = type2 = energyResource.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            TypeRenderer.render(poseStack, multiBufferSource, light, type);
        }
    }

    public static String format(long amount) {
        return FORMATTER.format(amount);
    }
}

