/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.soul;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.ultramega.refinedtypes.type.soul.SoulCapabilityCache;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.soul.SoulUtil;

public class SoulExtractableStorage
implements ExtractableStorage {
    private final SoulCapabilityCache capabilityCache;

    public SoulExtractableStorage(SoulCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof SoulResource)) {
            return 0L;
        }
        return this.capabilityCache.getCapability().map(handler -> {
            long amount = 0L;
            for (int i = 0; i < handler.getSoulTanks(); ++i) {
                amount += (long)handler.getSoulInTank(i);
            }
            return amount;
        }).orElse(0L);
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof SoulResource)) {
            return 0L;
        }
        return this.capabilityCache.getCapability().map(handler -> handler.drain((int)amount, SoulUtil.toSoulAction(action))).orElse(0).intValue();
    }
}

