/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import cy.jdkdigital.productivemetalworks.Config;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.util.RenderHelper;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;

public class FoundryControllerBlockEntityRenderer
implements BlockEntityRenderer<FoundryControllerBlockEntity> {
    public FoundryControllerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FoundryControllerBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (blockEntity.getMultiblockData() != null && ((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
            MultiBlockDetector.MultiBlockData multiBlockData = blockEntity.getMultiblockData();
            BlockPos c1 = (BlockPos)multiBlockData.topCorners().getFirst();
            BlockPos c2 = (BlockPos)multiBlockData.topCorners().getSecond();
            int xl1 = c1.getX() - multiBlockData.controllerPos().getX();
            int xl2 = c2.getX() - multiBlockData.controllerPos().getX();
            int[] xRange = IntStream.range(Math.min(xl1, xl2) + 1, Math.max(xl1, xl2)).toArray();
            int zl1 = c1.getZ() - multiBlockData.controllerPos().getZ();
            int zl2 = c2.getZ() - multiBlockData.controllerPos().getZ();
            int[] zRange = IntStream.range(Math.min(zl1, zl2) + 1, Math.max(zl1, zl2)).toArray();
            float fillPercentage = (float)blockEntity.fluidHandler.totalFluidAmount() / (float)blockEntity.fluidHandler.getCapacity();
            float fluidHeight = 1.0E-4f;
            for (int tank = 0; tank < blockEntity.fluidHandler.getTanks(); ++tank) {
                FluidStack fluidStack = blockEntity.fluidHandler.getFluidInTank(tank);
                if (blockEntity.getLevel() == null || fluidStack.isEmpty()) continue;
                poseStack.pushPose();
                int blocksFromBottom = multiBlockData.height() - (c1.getY() - multiBlockData.controllerPos().getY());
                VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
                float fluidFillPercentage = (float)fluidStack.getAmount() / (float)blockEntity.fluidHandler.totalFluidAmount() * 16.0f;
                float fluidYend = fluidHeight + fillPercentage * ((float)multiBlockData.height() * fluidFillPercentage - 1.0f) * RenderHelper.pixelFraction;
                float offsetY = -1.0f * (float)(blocksFromBottom - 1);
                poseStack.translate(0.0f, offsetY, 0.0f);
                RenderHelper.renderFullFluidLayer(poseStack, vertexBuffer, fluidHeight, fluidYend, xRange, zRange, fluidStack, combinedLightIn, combinedOverlayIn, 1.0f, 0.001f);
                fluidHeight = fluidYend;
                poseStack.popPose();
            }
            if (Config.foundryRenderInventory) {
                BoundingBox aabb = new BoundingBox(Math.min(c1.getX(), c2.getX()) + 1, c1.below(multiBlockData.height() - 1).getY(), Math.min(c1.getZ(), c2.getZ()) + 1, Math.max(c1.getX(), c2.getX()) - 1, c1.getY(), Math.max(c1.getZ(), c2.getZ()) - 1);
                List<BlockPos> positions = BlockPos.betweenClosedStream((BoundingBox)aabb).map(BlockPos::immutable).toList();
                for (int slot = 0; slot < blockEntity.getItemHandler().getSlots(); ++slot) {
                    ItemStack output = blockEntity.getItemHandler().getStackInSlot(slot);
                    if (output.isEmpty() || slot >= positions.size()) continue;
                    BlockPos pos = positions.get(slot);
                    poseStack.pushPose();
                    poseStack.translate((float)(pos.getX() - multiBlockData.controllerPos().getX()) + RenderHelper.halfPixelFraction, (float)(pos.getY() - multiBlockData.controllerPos().getY()) + RenderHelper.halfPixelFraction, (float)(pos.getZ() - multiBlockData.controllerPos().getZ()) + RenderHelper.halfPixelFraction);
                    poseStack.scale(1.0f - RenderHelper.pixelFraction, 1.0f - RenderHelper.pixelFraction, 1.0f - RenderHelper.pixelFraction);
                    Item item = output.getItem();
                    if (item instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockItem.getBlock().defaultBlockState(), poseStack, bufferSource, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
                    } else {
                        poseStack.translate(0.5f, 0.5f, 0.5f);
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        Minecraft.getInstance().getItemRenderer().renderStatic(output, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, blockEntity.getLevel(), 0);
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    public int getViewDistance() {
        return 32;
    }

    public AABB getRenderBoundingBox(FoundryControllerBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

