/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.mekanism.ChemicalCapabilityCache;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;

public class ChemicalInsertableStorage
implements InsertableStorage {
    private final ChemicalCapabilityCache capabilityCache;

    public ChemicalInsertableStorage(ChemicalCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof ChemicalResource)) {
            return 0L;
        }
        ChemicalResource chemicalResource = (ChemicalResource)resource;
        return this.capabilityCache.getCapability().map(fluidHandler -> ChemicalUtil.getCurrentAmount(fluidHandler, chemicalResource)).orElse(0L);
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof ChemicalResource)) {
            return 0L;
        }
        ChemicalResource chemicalResource = (ChemicalResource)resource;
        return this.capabilityCache.getCapability().map(handler -> this.insert(chemicalResource, amount, action, (IChemicalHandler)handler)).orElse(0L);
    }

    private long insert(ChemicalResource resource, long amount, Action action, IChemicalHandler chemicalHandler) {
        ChemicalStack stack = new ChemicalStack(resource.chemical(), amount);
        ChemicalStack remainder = chemicalHandler.insertChemical(stack, ChemicalUtil.toMekanismAction(action));
        return amount - remainder.getAmount();
    }
}

