/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.storage;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerBlockItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.content.Items;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ChemicalStorageBlockBlockItem
extends AbstractStorageContainerBlockItem
implements UpgradeableStorageContainer {
    private static final Component CREATIVE_HELP = MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation("item", "creative_chemical_storage_block.help");
    private final ChemicalStorageVariant variant;
    private final Component helpText;

    public ChemicalStorageBlockBlockItem(Block block, ChemicalStorageVariant variant) {
        super(block, new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = ChemicalStorageBlockBlockItem.getHelpText(variant);
    }

    private static Component getHelpText(ChemicalStorageVariant variant) {
        if (variant.getCapacityInBuckets() == null) {
            return CREATIVE_HELP;
        }
        return MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation("item", "chemical_storage_block.help", IdentifierUtil.format((long)variant.getCapacityInBuckets()));
    }

    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(ChemicalResource.class).formatAmount(amount);
    }

    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return ChemicalStorageBlockBlockItem.createStorage(this.variant, () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    static SerializableStorage createStorage(ChemicalStorageVariant variant, Runnable listener) {
        return ChemicalResourceType.STORAGE_TYPE.create(variant.getCapacity(), listener);
    }

    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Blocks.INSTANCE.getMachineCasing(), count);
    }

    @Nullable
    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        if (this.variant == ChemicalStorageVariant.CREATIVE) {
            return null;
        }
        return new ItemStack((ItemLike)Items.getChemicalStoragePart(this.variant), count);
    }

    protected boolean placeBlock(BlockPlaceContext ctx, BlockState state) {
        ServerPlayer serverPlayer;
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer && !RefinedStorageApi.INSTANCE.canPlaceNetworkNode(serverPlayer = (ServerPlayer)player, ctx.getLevel(), ctx.getClickedPos(), state)) {
            return false;
        }
        return super.placeBlock(ctx, state);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

