/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.storage;

import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceFactory;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.ModInitializer;
import com.refinedmods.refinedstorage.mekanism.content.BlockEntities;
import com.refinedmods.refinedstorage.mekanism.content.Menus;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ChemicalStorageBlockProvider
implements StorageBlockProvider {
    private final ChemicalStorageVariant variant;
    private final Component displayName;

    public ChemicalStorageBlockProvider(ChemicalStorageVariant variant) {
        this.variant = variant;
        this.displayName = MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation("block", String.format("%s_chemical_storage_block", variant.getName()));
    }

    public SerializableStorage createStorage(Runnable runnable) {
        return ChemicalResourceType.STORAGE_TYPE.create(this.variant.getCapacity(), runnable);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case ChemicalStorageVariant.SIXTY_FOUR_B -> ModInitializer.getConfig().getChemicalStorageBlock().get64bEnergyUsage();
            case ChemicalStorageVariant.TWO_HUNDRED_FIFTY_SIX_B -> ModInitializer.getConfig().getChemicalStorageBlock().get256bEnergyUsage();
            case ChemicalStorageVariant.THOUSAND_TWENTY_FOUR_B -> ModInitializer.getConfig().getChemicalStorageBlock().get1024bEnergyUsage();
            case ChemicalStorageVariant.EIGHT_THOUSAND_NINETY_TWO_B -> ModInitializer.getConfig().getChemicalStorageBlock().get8192bEnergyUsage();
            case ChemicalStorageVariant.CREATIVE -> ModInitializer.getConfig().getChemicalStorageBlock().getCreativeEnergyUsage();
        };
    }

    public ResourceFactory getResourceFactory() {
        return ChemicalResourceFactory.INSTANCE;
    }

    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntities.getChemicalStorageBlock(this.variant);
    }

    public MenuType<?> getMenuType() {
        return Menus.getChemicalStorage();
    }
}

