/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.common.button;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonItemStackCraftingGridSearchSync
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<?, ?>, TerminalStorageTabIngredientComponentCommon<?, ?>, ButtonImage> {
    private final String mod;
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private final Image image;
    private boolean active;

    public TerminalButtonItemStackCraftingGridSearchSync(String mod, TerminalStorageState state, ITerminalStorageTabClient<?> clientTab, Image image) {
        this.mod = mod;
        this.state = state;
        this.buttonName = "itemstack_grid_" + mod + "searchsync";
        this.clientTab = clientTab;
        this.image = image;
        this.reloadFromState();
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundTag data = (CompoundTag)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = data.getBoolean("active");
        } else {
            this.active = false;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ButtonImage createButton(int x, int y) {
        return new ButtonImage(x, y, (Component)Component.translatable((String)("gui.integratedterminalscompat.terminal_storage.craftinggrid." + this.mod + "sync")), b -> {}, new IImage[]{this.active ? Images.BUTTON_BACKGROUND_ACTIVE : Images.BUTTON_BACKGROUND_INACTIVE, this.image});
    }

    @Override
    public void onClick(TerminalStorageTabIngredientComponentClient<?, ?> clientTab, @Nullable TerminalStorageTabIngredientComponentCommon<?, ?> commonTab, ButtonImage guiButton, int channel, int mouseButton) {
        this.active = !this.active;
        CompoundTag data = new CompoundTag();
        data.putBoolean("active", this.active);
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (Tag)data);
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminalscompat.terminal_storage.craftinggrid." + this.mod + "sync";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(Player player, TooltipFlag tooltipFlag, List<Component> lines) {
        lines.add((Component)Component.translatable((String)("gui.integratedterminalscompat.terminal_storage.craftinggrid." + this.mod + "sync.info")).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)(this.active ? "general.cyclopscore.info.enabled" : "general.cyclopscore.info.disabled")).withStyle(ChatFormatting.ITALIC));
    }

    public boolean isActive() {
        return this.active;
    }

    public static boolean isSearchSynced(ITerminalStorageTabClient<?> clientTab) {
        for (ITerminalButton<?, ?, ?> button : clientTab.getButtons()) {
            if (!(button instanceof TerminalButtonItemStackCraftingGridSearchSync)) continue;
            return ((TerminalButtonItemStackCraftingGridSearchSync)button).isActive();
        }
        return false;
    }
}

