/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.items.stick;

import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.registry.ModDataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ItemStickBasic
extends ItemStick {
    private final Tier tier;

    public ItemStickBasic(Item.Properties properties, Tier tier) {
        super(properties.durability(tier.getUses()));
        this.tier = tier;
    }

    public boolean isDamageable(ItemStack stack) {
        return !stack.has(ModDataComponents.UNBREAKABLE) && super.isDamageable(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) || stack.has(ModDataComponents.BATTERY);
    }

    public int getBarWidth(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.has(ModDataComponents.BATTERY_ENABLED) && (storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            return Math.round(13.0f / (float)storage.getMaxEnergyStored() * (float)storage.getEnergyStored());
        }
        return super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        if (stack.has(ModDataComponents.BATTERY_ENABLED)) {
            return 9901575;
        }
        return super.getBarColor(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return ConstructionConfig.getStickProperties(this).getDurability();
    }

    @Override
    public int remainingDurability(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.has(ModDataComponents.UNBREAKABLE)) {
            return Integer.MAX_VALUE;
        }
        if (stack.has(ModDataComponents.BATTERY_ENABLED) && (storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            int usage = ConstructionConfig.getStickProperties(this).getBatteryUsage();
            return storage.getEnergyStored() / usage;
        }
        return stack.getMaxDamage() - stack.getDamageValue();
    }

    @Override
    public boolean isValidRepairItem(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return this.tier.getRepairIngredient().test(repair);
    }
}

