/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick.undo;

import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.stick.StickItemUseContext;
import mrbysco.constructionstick.stick.undo.ISnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PlaceSnapshot
implements ISnapshot {
    private BlockState block;
    private final BlockPos pos;
    private final BlockItem item;
    private final BlockState supportingBlock;
    private final boolean targetMode;

    public PlaceSnapshot(BlockState block, BlockPos pos, BlockItem item, BlockState supportingBlock, boolean targetMode) {
        this.block = block;
        this.pos = pos;
        this.item = item;
        this.supportingBlock = supportingBlock;
        this.targetMode = targetMode;
    }

    public static PlaceSnapshot get(Level level, Player player, BlockHitResult blockHitResult, BlockPos pos, BlockItem item, @Nullable BlockState supportingBlock, @Nullable StickOptions options) {
        boolean targetMode = options != null && supportingBlock != null && options.direction.get() == StickOptions.DIRECTION.TARGET;
        BlockState blockState = PlaceSnapshot.getPlaceBlockstate(level, player, blockHitResult, pos, item, supportingBlock, targetMode);
        if (blockState == null) {
            return null;
        }
        return new PlaceSnapshot(blockState, pos, item, supportingBlock, targetMode);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return new ItemStack((ItemLike)this.item);
    }

    @Override
    public boolean execute(Level level, Player player, BlockHitResult blockHitResult) {
        this.block = PlaceSnapshot.getPlaceBlockstate(level, player, blockHitResult, this.pos, this.item, this.supportingBlock, this.targetMode);
        if (this.block == null) {
            return false;
        }
        return StickUtil.placeBlock(level, player, this.block, this.pos, this.item);
    }

    @Override
    public boolean canRestore(Level level, Player player) {
        return true;
    }

    @Override
    public boolean restore(Level level, Player player) {
        return StickUtil.removeBlock(level, player, this.block, this.pos);
    }

    @Override
    public void forceRestore(Level level) {
        level.removeBlock(this.pos, false);
    }

    @Nullable
    private static BlockState getPlaceBlockstate(Level level, Player player, BlockHitResult blockHitResult, BlockPos pos, BlockItem item, @Nullable BlockState supportingBlock, boolean targetMode) {
        StickItemUseContext ctx = new StickItemUseContext(level, player, blockHitResult, pos, item);
        if (!ctx.canPlace()) {
            return null;
        }
        BlockState blockState = item.getBlock().getStateForPlacement((BlockPlaceContext)ctx);
        if (blockState == null || !blockState.canSurvive((LevelReader)level, pos)) {
            return null;
        }
        if (!StickUtil.isTEAllowed(blockState)) {
            return null;
        }
        if (StickUtil.entitiesCollidingWithBlock(level, blockState, pos)) {
            return null;
        }
        if (targetMode && supportingBlock != null) {
            SlabType slabType;
            for (Property property : new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.FACING, BlockStateProperties.FACING_HOPPER, BlockStateProperties.ROTATION_16, BlockStateProperties.AXIS, BlockStateProperties.HALF, BlockStateProperties.STAIRS_SHAPE}) {
                if (!supportingBlock.hasProperty(property) || !blockState.hasProperty(property)) continue;
                blockState = (BlockState)blockState.setValue(property, supportingBlock.getValue(property));
            }
            if (supportingBlock.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && blockState.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && (slabType = (SlabType)supportingBlock.getValue((Property)BlockStateProperties.SLAB_TYPE)) != SlabType.DOUBLE) {
                blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)slabType);
            }
        }
        return blockState;
    }
}

