/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;

public class EmergencyItemsScreen
extends BaseScreen {
    private static long endTime = 0L;
    private final SimpleTextButton getItemsButton;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public EmergencyItemsScreen() {
        if (endTime < Util.getEpochMillis()) {
            endTime = Util.getEpochMillis() + (long)ClientQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L;
        }
        this.itemPanel = new ItemPanel();
        this.cancelButton = SimpleTextButton.cancel((Panel)this, mb -> this.closeGui(), (Component[])new Component[0]);
        this.getItemsButton = new SimpleTextButton(this, (Panel)this, (Component)Component.translatable((String)"ftbquests.file.emergency_items.get_items"), Icons.ACCEPT){

            public void onClicked(MouseButton button) {
                if (Util.getEpochMillis() >= endTime) {
                    this.playClickSound();
                    NetworkManager.sendToServer((CustomPacketPayload)GetEmergencyItemsMessage.INSTANCE);
                    endTime = Util.getEpochMillis() + (long)ClientQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L;
                }
            }

            public void tick() {
                MutableComponent c = Component.translatable((String)"ftbquests.file.emergency_items.get_items");
                this.setTitle((Component)(Util.getEpochMillis() >= endTime ? c : c.withStyle(ChatFormatting.DARK_GRAY)));
            }
        };
    }

    public static void resetCooldown() {
        endTime = 0L;
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.add((Widget)this.getItemsButton);
        this.cancelButton.setPos(this.width / 2 - this.cancelButton.width - 5, this.height * 2 / 3 + 16);
        this.getItemsButton.setPos(this.cancelButton.getX() + this.cancelButton.getWidth() + 10, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)((int)((double)w / 2.0)), (float)((int)((double)h / 5.0)), 0.0f);
        poseStack.scale(2.0f, 2.0f, 1.0f);
        MutableComponent titleMsg = Component.translatable((String)"ftbquests.file.emergency_items");
        theme.drawString(graphics, (Object)titleMsg, -theme.getStringWidth((FormattedText)titleMsg) / 2, 0, Color4I.WHITE, 0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((float)((int)((double)w / 2.0)), (float)((int)((double)h / 2.5)), 0.0f);
        poseStack.scale(4.0f, 4.0f, 1.0f);
        long timeLeft = endTime - Util.getEpochMillis();
        String timeStr = timeLeft <= 0L ? "00:00" : TimeUtils.getTimeString((long)(timeLeft / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(timeStr) / 2;
        theme.drawString(graphics, (Object)timeStr, x1 - 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1 + 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1, 1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1, -1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)timeStr, x1, 0, Color4I.WHITE, 0);
        poseStack.popPose();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ItemPanel
    extends Panel {
        public ItemPanel() {
            super((Panel)EmergencyItemsScreen.this);
        }

        public void addWidgets() {
            ClientQuestFile.INSTANCE.getEmergencyItems().forEach(stack -> this.add(new EmergencyItemWidget(this, (ItemStack)stack)));
        }

        public void alignWidgets() {
            this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
            this.setHeight(22);
            this.setPos((EmergencyItemsScreen.this.width - EmergencyItemsScreen.this.itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
        }
    }

    private static class EmergencyItemWidget
    extends Widget {
        private final ItemStack stack;

        public EmergencyItemWidget(Panel panel, ItemStack stack) {
            super(panel);
            this.stack = stack;
            this.setY(3);
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList l = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.stack, l);
            l.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get("rsquare").getOutline().draw(graphics, x - 3, y - 3, w + 6, h + 6);
            graphics.pose().pushPose();
            graphics.pose().translate((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            GuiHelper.drawItem((GuiGraphics)graphics, (ItemStack)this.stack, (int)0, (boolean)true, null);
            graphics.pose().popPose();
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of((Object)this.stack, (Widget)this);
        }
    }
}

