/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.MoveMovableResponseMessage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;

public record MoveMovableMessage(long id, long chapterID, double x, double y) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MoveMovableMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("move_movable_message"));
    public static final StreamCodec<FriendlyByteBuf, MoveMovableMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, MoveMovableMessage::id, (StreamCodec)ByteBufCodecs.VAR_LONG, MoveMovableMessage::chapterID, (StreamCodec)ByteBufCodecs.DOUBLE, MoveMovableMessage::x, (StreamCodec)ByteBufCodecs.DOUBLE, MoveMovableMessage::y, MoveMovableMessage::new);

    public CustomPacketPayload.Type<MoveMovableMessage> type() {
        return TYPE;
    }

    public static void handle(MoveMovableMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            QuestObject patt0$temp = ServerQuestFile.INSTANCE.get(message.id);
            if (patt0$temp instanceof Movable) {
                Movable movable = (Movable)((Object)patt0$temp);
                movable.onMoved(message.x, message.y, message.chapterID);
                ServerQuestFile.INSTANCE.markDirty();
                NetworkHelper.sendToAll((MinecraftServer)ServerQuestFile.INSTANCE.server, (CustomPacketPayload)new MoveMovableResponseMessage(movable.getMovableID(), message.chapterID, message.x, message.y));
            }
        });
    }
}

