/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;

public class WeightedReward
implements Comparable<WeightedReward> {
    private final Reward reward;
    private float weight;

    public WeightedReward(Reward reward, float weight) {
        this.reward = reward;
        this.weight = Math.max(weight, 0.0f);
    }

    public Reward getReward() {
        return this.reward;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public static String chanceString(float weight, float totalWeight, boolean empty) {
        if (totalWeight <= 0.0f) {
            return "??%";
        }
        if (weight <= 0.0f) {
            return empty ? "0%" : "100%";
        }
        if (weight >= totalWeight) {
            return "100%";
        }
        int chance = (int)(weight * 100.0f / totalWeight);
        float chanced = weight * 100.0f / totalWeight;
        if ((float)chance != chanced) {
            return chanced < 0.01f ? "<0.01%" : String.format("%.2f%%", Float.valueOf(chanced));
        }
        return chance + "%";
    }

    public static String chanceString(float weight, float totalWeight) {
        return WeightedReward.chanceString(weight, totalWeight, false);
    }

    @Override
    public int compareTo(WeightedReward o) {
        return Float.compare(this.weight, o.weight);
    }

    public WeightedReward copy() {
        Reward r = QuestObjectBase.copy(this.reward, () -> RewardType.createReward(this.reward.id, this.reward.getQuest(), this.reward.getType().getTypeId().toString()));
        return new WeightedReward(r, this.weight);
    }
}

