/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.translation;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.NameMap;
import java.util.List;

public enum TranslationKey {
    TITLE("title", false),
    QUEST_SUBTITLE("quest_subtitle", false),
    QUEST_DESC("quest_desc", true),
    CHAPTER_SUBTITLE("chapter_subtitle", true);

    public static final NameMap<TranslationKey> NAME_MAP;
    private final String name;
    private final boolean isListVal;

    private TranslationKey(String name, boolean isListVal) {
        this.name = name;
        this.isListVal = isListVal;
    }

    public String getName() {
        return this.name;
    }

    public boolean isListVal() {
        return this.isListVal;
    }

    public Either<String, List<String>> validate(Either<String, List<String>> either) {
        either.ifLeft(s -> {
            if (this.isListVal) {
                throw new IllegalArgumentException("expected a list value!");
            }
        }).ifRight(l -> {
            if (!this.isListVal) {
                throw new IllegalArgumentException("expected a string value!");
            }
        });
        return either;
    }

    public String getTranslationKey() {
        return "ftbquests.translation_key." + this.name;
    }

    static {
        NAME_MAP = NameMap.of((Object)((Object)TITLE), (Object[])TranslationKey.values()).id(v -> v.name).create();
    }
}

