/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.loot;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.loot.BalmLootTables;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.FarmlandHandler;
import net.blay09.mods.farmingforblockheads.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ModLootModifiers {
    public static void initialize(BalmLootTables lootTables) {
        lootTables.registerLootModifier(ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"rich_farmland"), (context, loot) -> {
            CropBlock crop;
            ServerLevel level = context.getLevel();
            Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
            BlockState plant = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
            if (origin == null || plant == null || !(plant.getBlock() instanceof BonemealableBlock)) {
                return;
            }
            BlockPos pos = BlockPos.containing((Position)origin);
            ChunkPos chunkPos = new ChunkPos(pos);
            if (!level.getChunkSource().hasChunk(chunkPos.x, chunkPos.z)) {
                return;
            }
            Block patt0$temp = plant.getBlock();
            if (patt0$temp instanceof CropBlock && !(crop = (CropBlock)patt0$temp).isMaxAge(plant)) {
                return;
            }
            BlockPos posBelow = pos.below();
            BlockState farmland = level.getBlockState(posBelow);
            if (farmland.is(ModBlockTags.RICH_FARMLAND)) {
                float bonusCropChance = (float)FarmingForBlockheadsConfig.getActive().fertilizerBonusCropChance;
                if (Math.random() <= (double)bonusCropChance) {
                    loot.stream().filter(p -> !ModLootModifiers.isProbablySeed(p)).findAny().ifPresent(arg_0 -> ModLootModifiers.lambda$initialize$1(loot, (Level)level, pos, posBelow, farmland, arg_0));
                }
            }
        });
    }

    private static boolean isProbablySeed(ItemStack itemStack) {
        ResourceLocation registryName = Balm.getRegistries().getKey(itemStack.getItem());
        return registryName != null && registryName.getPath().contains("seed");
    }

    private static /* synthetic */ void lambda$initialize$1(List loot, Level level, BlockPos pos, BlockPos posBelow, BlockState farmland, ItemStack c) {
        loot.add(c.copy());
        level.levelEvent(2005, pos, 0);
        FarmlandHandler.rollRegression(level, posBelow, farmland);
    }
}

