/*
 * Decompiled with CFR 0.152.
 */
package ru.yurannnzzz.moreredcccompat;

import commoble.morered.api.MoreRedAPI;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.redstone.BundledRedstoneProvider;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import ru.yurannnzzz.moreredcccompat.cc.MoreRedBundledRedstoneProvider;
import ru.yurannnzzz.moreredcccompat.morered.ComputerChanneledPowerCapability;
import ru.yurannnzzz.moreredcccompat.morered.ComputerWireConnector;

@Mod(value="moreredxcctcompat")
public class MoreRedCCCompatMod {
    public static final String MOD_ID = "moreredxcctcompat";
    private static final Map<Block, BlockEntityType<?>> BLOCKS = new HashMap();

    public MoreRedCCCompatMod(IEventBus modEventBus) {
        modEventBus.addListener(this::registerConnectors);
        modEventBus.addListener(this::registerCapabilities);
        ComputerCraftAPI.registerBundledRedstoneProvider((BundledRedstoneProvider)new MoreRedBundledRedstoneProvider());
    }

    private void registerConnectors(FMLCommonSetupEvent event) {
        ComputerWireConnector connector = new ComputerWireConnector();
        Map registry = MoreRedAPI.getCableConnectabilityRegistry();
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!(block instanceof IBundledRedstoneBlock)) continue;
            Optional<BlockEntityType> filter = BuiltInRegistries.BLOCK_ENTITY_TYPE.stream().filter(it -> it.isValid(block.defaultBlockState())).findFirst();
            filter.ifPresent(blockEntityType -> BLOCKS.put(block, (BlockEntityType<?>)blockEntityType));
        }
        for (Map.Entry<Block, BlockEntityType<?>> entry : BLOCKS.entrySet()) {
            registry.put(entry.getKey(), connector);
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (Map.Entry<Block, BlockEntityType<?>> entry : BLOCKS.entrySet()) {
            event.registerBlockEntity(MoreRedAPI.CHANNELED_POWER_CAPABILITY, entry.getValue(), (be, side) -> new ComputerChanneledPowerCapability((Direction)side));
        }
    }
}

