/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel_patcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void compress(File src, File dst) throws IOException {
        if (!dst.getName().endsWith(".zip")) {
            throw new RuntimeException("Invalid zip " + String.valueOf(dst));
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(dst));
        File[] children = src.listFiles();
        if (children != null) {
            for (File child : children) {
                ZipUtils.zipFile(child, "", out);
            }
        }
        out.close();
    }

    private static void zipFile(File src, String path, ZipOutputStream out) throws IOException {
        if (src.isDirectory()) {
            String dirPath = path + src.getName();
            if (!src.getName().endsWith("/")) {
                dirPath = dirPath + "/";
            }
            out.putNextEntry(new ZipEntry(dirPath));
            File[] children = src.listFiles();
            if (children == null) {
                return;
            }
            for (File child : children) {
                ZipUtils.zipFile(child, dirPath, out);
            }
        } else if (src.isFile()) {
            FileInputStream in = new FileInputStream(src);
            out.putNextEntry(new ZipEntry(path + src.getName()));
            in.transferTo(out);
            in.close();
        }
    }

    public static void extract(InputStream stream, File dstFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            File dst = ZipUtils.newFile(dstFolder, entry);
            if (entry.isDirectory()) {
                if (dst.exists() || dst.mkdirs()) continue;
                throw new IOException("Could not mkdir " + String.valueOf(dst));
            }
            File parent = dst.getParentFile();
            if (parent.isDirectory() && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("Could not mkdir " + parent.getName());
            }
            if (!dst.exists() && !dst.createNewFile()) {
                throw new IOException("Could not touch " + dst.getName());
            }
            FileOutputStream out = new FileOutputStream(dst);
            zip.transferTo(out);
            out.close();
        }
        zip.closeEntry();
        zip.close();
    }

    private static File newFile(File dstFolder, ZipEntry zipEntry) throws IOException {
        File dstFile = new File(dstFolder, zipEntry.getName());
        String dstDirPath = dstFolder.getCanonicalPath();
        String dstFilePath = dstFile.getCanonicalPath();
        if (!dstFilePath.startsWith(dstDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return dstFile;
    }
}

