/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.block;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.zeroregard.ars_technica.Config;
import com.zeroregard.ars_technica.block.SourceMotorBlock;
import com.zeroregard.ars_technica.registry.BlockRegistry;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import com.zeroregard.ars_technica.registry.SoundRegistry;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SourceMotorBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int MAX_SPEED = 256;
    protected boolean fueled = false;
    protected boolean hasRedstoneSignal = false;
    protected ScrollValueBehaviour generatedSpeed;
    public int generatedStressUnitsRatio = 100;
    protected int tickCount = 0;

    public boolean isFueled() {
        return this.fueled;
    }

    public void setGeneratedStressUnitsRatio(int ratio) {
        this.generatedStressUnitsRatio = ratio;
        this.updateGeneratedRotation();
    }

    public void setPowered(boolean powered) {
        boolean willRun;
        boolean wasRunning = !this.hasRedstoneSignal && this.fueled;
        this.hasRedstoneSignal = powered;
        boolean bl = willRun = !this.hasRedstoneSignal && this.fueled;
        if (wasRunning != willRun) {
            this.onRotationStateChanged();
        } else {
            this.notifyUpdate();
        }
    }

    public float calculateAddedStressCapacity() {
        float capacity = (float)BlockStressValues.getCapacity((Block)this.getStressConfigKey());
        int ratioMultipliedCapacity = Math.round(this.getStressCapacityMultiplier() * capacity);
        this.lastCapacityProvided = ratioMultipliedCapacity;
        return ratioMultipliedCapacity;
    }

    private float getStressCapacityMultiplier() {
        return (float)this.generatedStressUnitsRatio / 100.0f;
    }

    public SourceMotorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityRegistry.SOURCE_MOTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox(this));
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 0;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.generatedStressUnitsRatio = compound.getInt("GeneratedStressUnitsRatio");
        this.fueled = compound.getBoolean("Fueled");
        this.hasRedstoneSignal = compound.getBoolean("HasRedstoneSignal");
        super.read(compound, registries, clientPacket);
    }

    protected void writeCommon(CompoundTag compound) {
        compound.putInt("GeneratedStressUnitsRatio", this.generatedStressUnitsRatio);
        compound.putBoolean("Fueled", this.fueled);
        compound.putBoolean("HasRedstoneSignal", this.hasRedstoneSignal);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.writeCommon(compound);
        super.write(compound, registries, clientPacket);
    }

    public void writeSafe(CompoundTag compound, HolderLookup.Provider registries) {
        this.writeCommon(compound);
        super.writeSafe(compound, registries);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        if (this.overStressed) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.source_consumption", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.fueled && !this.hasRedstoneSignal) {
            int sourceCostTotal = this.getSourceCost();
            CreateLang.number((double)sourceCostTotal).space().translate("ars_nouveau.unit.source", new Object[0]).style(ChatFormatting.DARK_PURPLE).space().add(CreateLang.translate((String)"gui.goggles.per_second", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        if (this.hasRedstoneSignal) {
            CreateLang.translate((String)"ars_nouveau.has_redstone_signal", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
        } else if (!this.fueled) {
            CreateLang.translate((String)"ars_nouveau.lacks_source", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        }
        return true;
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (this.tickCount % 20 == 0 && !this.hasRedstoneSignal) {
            this.consumeSource();
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    protected void consumeSource() {
        int sourceCost = this.getSourceCost();
        if (sourceCost == 0) {
            return;
        }
        boolean success = SourceUtil.takeSourceMultipleWithParticles((BlockPos)this.worldPosition, (Level)this.level, (int)10, (int)sourceCost) != null;
        boolean fueledStateChanged = success != this.fueled;
        this.fueled = success;
        if (fueledStateChanged) {
            this.onRotationStateChanged();
            this.notifyUpdate();
        }
    }

    private void onRotationStateChanged() {
        this.updateGeneratedRotation();
        Vec3 pos = this.getBlockPos().getCenter();
        SoundEvent event = this.fueled && !this.hasRedstoneSignal ? (SoundEvent)SoundRegistry.SOURCE_MOTOR_START.get() : (SoundEvent)SoundRegistry.SOURCE_MOTOR_STOP.get();
        this.getLevel().playSound(null, pos.x, pos.y, pos.z, event, SoundSource.BLOCKS, 0.25f, 1.0f);
    }

    private int getSourceCost() {
        if (this.overStressed) {
            return 0;
        }
        int absoluteSpeed = Math.abs(this.generatedSpeed.value);
        double rawSourceCost = (double)absoluteSpeed * (Double)Config.Common.SOURCE_MOTOR_SPEED_TO_SOURCE_MULTIPLIER.get();
        float stressCapacityMultiplier = this.getStressCapacityMultiplier();
        if (stressCapacityMultiplier == 0.0f) {
            return 0;
        }
        int sourceCost = (int)Math.round((double)stressCapacityMultiplier * rawSourceCost);
        if (sourceCost == 0) {
            return 1;
        }
        return sourceCost;
    }

    public float getGeneratedSpeed() {
        if (!this.fueled || this.hasRedstoneSignal) {
            return 0.0f;
        }
        if (!((SourceMotorBlock)((Object)BlockRegistry.SOURCE_MOTOR.get())).defaultBlockState().is(this.getBlockState().getBlock())) {
            return 0.0f;
        }
        float speed = SourceMotorBlockEntity.convertToDirection((float)this.generatedSpeed.value, (Direction)((Direction)this.getBlockState().getValue((Property)SourceMotorBlock.FACING)));
        return speed;
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox(SourceMotorBlockEntity this$0) {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.getValue((Property)SourceMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.getValue((Property)SourceMotorBlock.FACING);
            if (facing.getAxis() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZDegrees(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.getValue((Property)SourceMotorBlock.FACING);
            if (facing.getAxis() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.getAxis() != facing.getAxis();
        }
    }
}

