/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity;

import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.zeroregard.ars_technica.helpers.ConsumptionHelper;
import com.zeroregard.ars_technica.helpers.ProjectileHelper;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemProjectileEntity
extends Entity {
    private ItemStack itemStack = ItemStack.EMPTY;
    private Vec3 velocity = Vec3.ZERO;
    private final Level world;
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final int MAXIMUM_LIFE_TIME_TICKS = 200;
    private int ticks = 0;

    @Nullable
    public ItemStack getStack() {
        return this.itemStack;
    }

    public ItemProjectileEntity(EntityType<ItemProjectileEntity> type, Level world) {
        super(type, world);
        this.world = world;
    }

    public ItemProjectileEntity(Level world, Vec3 position, Vec3 direction, ItemStack itemStack) {
        this((EntityType<ItemProjectileEntity>)((EntityType)EntityRegistry.ITEM_PROJECTILE_ENTITY.get()), world);
        this.setPos(position);
        this.velocity = direction.scale(0.2);
        this.itemStack = itemStack.copy();
        this.entityData.set(ITEM_STACK, (Object)itemStack);
    }

    public void tick() {
        HitResult rayTrace;
        super.tick();
        ++this.ticks;
        if (this.ticks >= 200) {
            this.discard();
        }
        this.setDeltaMovement(this.velocity);
        this.move(MoverType.SELF, this.velocity);
        if (!this.world.isClientSide && (rayTrace = ProjectileHelper.getHitResult(this, this::shouldEntityCollide, this::shouldBlockEntityCollide)) != null) {
            this.onImpact(rayTrace);
            this.discard();
        }
        if (!this.world.isInWorldBounds(this.blockPosition())) {
            this.discard();
        }
    }

    private boolean shouldEntityCollide(Entity entity) {
        return entity instanceof LivingEntity;
    }

    private <T extends BlockEntity> boolean shouldBlockEntityCollide(T entity) {
        BlockState blockState;
        if (entity instanceof PortalTile) {
            return false;
        }
        BlockPos blockPos = entity.getBlockPos();
        IItemHandler itemHandler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.world, blockPos, blockState = entity.getBlockState(), entity, null);
        boolean isItemHandler = itemHandler != null;
        IFluidHandler fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(this.world, blockPos, blockState, entity, null);
        boolean isFluidHandler = fluidHandler != null;
        return !isItemHandler && !isFluidHandler;
    }

    private void onImpact(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            this.handleEntityImpact(entityHit.getEntity());
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            this.handleBlockImpact(blockHit.getBlockPos());
        }
    }

    private void handleEntityImpact(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (ConsumptionHelper.tryUseEdibleItem(target, this.itemStack, this.world)) {
                return;
            }
            if (ConsumptionHelper.tryUseConsumableItem(target, this.itemStack, this.world, true)) {
                return;
            }
        }
    }

    private void handleBlockImpact(BlockPos pos) {
        this.discard();
    }

    protected void defineSynchedData(SynchedEntityData.Builder dataBuilder) {
        dataBuilder.define(ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (ITEM_STACK.equals(key)) {
            this.itemStack = (ItemStack)this.entityData.get(ITEM_STACK);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.itemStack = ItemStack.parseOptional((HolderLookup.Provider)this.world.registryAccess(), (CompoundTag)tag.getCompound("Item"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("Item", this.itemStack.save((HolderLookup.Provider)this.world.registryAccess(), (Tag)new CompoundTag()));
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

