/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import com.zeroregard.ars_technica.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ObliterateHelper {
    private static final int MAX_FORTUNE_DISPLAY_LEVEL = 4;

    private ObliterateHelper() {
    }

    public static float getFortuneChanceMultiplier(int fortuneLevel) {
        if (fortuneLevel <= 0) {
            return 1.0f;
        }
        double base = (Double)Config.Common.OBLITERATE_FORTUNE_BASE_CHANCE.get();
        double multiplier = 1.0 + 2.0 * base * (1.0 - Math.pow(0.5, fortuneLevel));
        return (float)multiplier;
    }

    public static boolean isChanceCapped(float baseChance) {
        return baseChance >= 1.0f;
    }

    public static Component createHoldPrompt(Component keyName) {
        return Component.translatable((String)"tooltip.ars_technica.obliterate.hold", (Object[])new Object[]{keyName.copy().withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY);
    }

    public static List<Component> createFortuneDetails(float baseChance) {
        ArrayList<Component> lines = new ArrayList<Component>();
        float basePercent = Math.min(baseChance, 1.0f) * 100.0f;
        String baseValue = String.format(Locale.ROOT, "%.2f%% Chance", Float.valueOf(basePercent));
        lines.add((Component)Component.literal((String)"Base: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)baseValue).withStyle(ChatFormatting.GOLD)));
        for (int level = 1; level <= 4; ++level) {
            float chance = ObliterateHelper.getFortuneChanceMultiplier(level) * baseChance;
            chance = Math.min(chance, 1.0f);
            String value = String.format(Locale.ROOT, "%.2f%% Chance", Float.valueOf(chance * 100.0f));
            MutableComponent line = Component.literal((String)"+%d Luck: ".formatted(level)).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)value).withStyle(ChatFormatting.GOLD));
            lines.add((Component)line);
        }
        return lines;
    }
}

