/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ProjectileHelper {
    public static HitResult getHitResult(Entity projectile, Predicate<Entity> entityFilter, Predicate<BlockEntity> blockEntityFilter) {
        Vec3 end;
        Vec3 start;
        BlockHitResult blockHit;
        BlockPos blockPos;
        Level world = projectile.level();
        BlockState blockState = world.getBlockState(blockPos = (blockHit = world.clip(new ClipContext(start = projectile.getEyePosition(1.0f), end = start.add(projectile.getDeltaMovement()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, projectile))).getBlockPos());
        if (blockState.isAir()) {
            blockHit = null;
        } else {
            BlockEntity be = world.getBlockEntity(blockPos);
            if (be != null && !blockEntityFilter.test(be)) {
                blockHit = null;
            }
        }
        if (blockHit != null) {
            return blockHit;
        }
        return ProjectileHelper.getEntityHitResult(world, projectile, start, end, projectile.getBoundingBox().expandTowards(projectile.getDeltaMovement()).inflate(0.5), entityFilter);
    }

    private static EntityHitResult getEntityHitResult(Level world, Entity projectile, Vec3 start, Vec3 end, AABB boundingBox, Predicate<Entity> entityFilter) {
        EntityHitResult closestEntityHit = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : world.getEntities(projectile, boundingBox, entityFilter)) {
            double distance;
            AABB entityBoundingBox = entity.getBoundingBox().inflate(0.5);
            Optional intersection = entityBoundingBox.clip(start, end);
            if (!intersection.isPresent() || !((distance = start.distanceTo((Vec3)intersection.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntityHit = new EntityHitResult(entity, (Vec3)intersection.get());
        }
        return closestEntityHit;
    }
}

