/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers.mixin;

import com.zeroregard.ars_technica.helpers.mixin.droppers.IDropper;
import com.zeroregard.ars_technica.item.RunicSpanner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ArsTechnicaWrenchable {
    public static InteractionResult onSneakWrenched(BlockState state, UseOnContext context, IDropper itemDropper) {
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        if (stack.getItem() instanceof RunicSpanner) {
            Level world = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            Vec3 centerPos = pos.getCenter();
            itemDropper.dropItem(world, pos, state, player);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                BlockState blockState = world.getBlockState(pos);
                BlockParticleOption data = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
                serverLevel.sendParticles((ParticleOptions)data, centerPos.x, centerPos.y, centerPos.z, 30, 0.25, 0.25, 0.25, 0.0);
            }
            ArsTechnicaWrenchable.playRemoveSound(world, pos, state.getSoundType());
            world.removeBlock(pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private static void playRemoveSound(Level world, BlockPos pos, SoundType soundType) {
        world.playSound(null, pos, soundType.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

