/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.gui.SimChamberContainer;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.tile.SimChamberTileEntity;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import dev.shadowsoffire.placebo.screen.TickableTextList;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.common.extensions.IAttributeExtension;

public class SimChamberScreen
extends PlaceboContainerScreen<SimChamberContainer> {
    public static final int WIDTH = 232;
    public static final int HEIGHT = 230;
    public static final int MAX_TEXT_WIDTH = 174;
    public static final float RUNTIME_TEXT_SPEED = 0.65f;
    private static final ResourceLocation BASE = HostileNetworks.loc("textures/gui/sim_chamber.png");
    private static final ResourceLocation PLAYER = HostileNetworks.loc("textures/gui/default_gui.png");
    private TickableTextList body;
    private SimChamberTileEntity.FailureState lastFailState = SimChamberTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final Component ERROR = Component.literal((String)"ERROR").withStyle(ChatFormatting.OBFUSCATED);

    public SimChamberScreen(SimChamberContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 232;
        this.imageHeight = 230;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new RedstoneButton(this.getGuiLeft() + 228, this.getGuiTop()));
        this.body = new TickableTextList(this.minecraft.font, 174);
        this.lastFailState = SimChamberTileEntity.FailureState.NONE;
        this.runtimeTextLoaded = false;
        this.containerTick();
    }

    protected void renderTooltip(GuiGraphics gfx, int pX, int pY) {
        if (this.isHovering(211, 48, 7, 87, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.translatable((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((SimChamberContainer)this.menu).getEnergyStored(), HostileConfig.simPowerCap}));
            DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
            if (cModel.isValid()) {
                txt.add(Component.translatable((String)"hostilenetworks.gui.cost", (Object[])new Object[]{cModel.getModel().simCost()}));
            }
            gfx.renderComponentTooltip(this.font, txt, pX, pY);
        } else if (this.isHovering(14, 48, 7, 87, pX, pY)) {
            DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
            if (cModel.isValid()) {
                ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(1);
                if (!cModel.getTier().isMax()) {
                    txt.add(Component.translatable((String)"hostilenetworks.gui.data", (Object[])new Object[]{cModel.getData() - cModel.getTierData(), cModel.getNextTierData() - cModel.getTierData()}));
                } else {
                    txt.add(Component.translatable((String)"hostilenetworks.gui.max_data").withStyle(ChatFormatting.RED));
                }
                gfx.renderComponentTooltip(this.font, txt, pX, pY);
            }
        } else if (this.isHovering(229, 1, 16, 16, pX, pY)) {
            gfx.renderTooltip(this.font, (Component)Component.translatable((String)((SimChamberContainer)this.menu).getRedstoneState().getKey()), pX, pY);
        } else {
            super.renderTooltip(gfx, pX, pY);
        }
    }

    protected void renderLabels(GuiGraphics gfx, int pX, int pY) {
        DataModelInstance model;
        int runtime = ((SimChamberContainer)this.menu).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, Mth.ceil((float)(100.0f * (float)(300 - runtime) / 300.0f)));
            gfx.drawString(this.font, rTime + "%", 184, 123, 6478079, true);
        }
        if ((model = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0)).isValid()) {
            int xOff = 18;
            MutableComponent msg = Component.translatable((String)"hostilenetworks.gui.target", (Object[])new Object[]{model.getModel().name().copy().withColor(65472)});
            gfx.drawString(this.font, (Component)msg, xOff, 9, 0xFFFFFF);
            msg = Component.translatable((String)"hostilenetworks.gui.tier", (Object[])new Object[]{model.getTier().getComponent()});
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, (Component)msg, xOff, 9 + 9 + 3, 0xFFFFFF);
            MutableComponent accuracy = Component.literal((String)IAttributeExtension.FORMAT.format(model.getAccuracy())).withColor(model.getTier().colorValue());
            msg = Component.translatable((String)"hostilenetworks.gui.accuracy", (Object[])new Object[]{accuracy});
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, (Component)msg, xOff, 9 + (9 + 3) * 2, 0xFFFFFF);
        }
        this.body.render(gfx, 29.0f, 51.0f);
    }

    protected void renderBg(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.blit(BASE, left + 8, top, 0.0f, 0.0f, 216, 141, 256, 256);
        gfx.blit(BASE, left - 14, top, 0.0f, 141.0f, 18, 18, 256, 256);
        gfx.blit(BASE, left + 228, top, 0.0f, 141.0f, 18, 18, 256, 256);
        int energyHeight = 87 - Mth.ceil((float)(87.0f * (float)((SimChamberContainer)this.menu).getEnergyStored() / (float)HostileConfig.simPowerCap));
        gfx.blit(BASE, left + 211, top + 48, 18.0f, 141.0f, 7, energyHeight, 256, 256);
        int dataHeight = 87;
        DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
        if (cModel.isValid()) {
            int data = cModel.getData();
            ModelTier tier = cModel.getTier();
            dataHeight = tier.isMax() ? 0 : 87 - Mth.ceil((float)(87.0f * (float)(data - cModel.getTierData()) / (float)(cModel.getNextTierData() - cModel.getTierData())));
        }
        gfx.blit(BASE, left + 14, top + 48, 18.0f, 141.0f, 7, dataHeight, 256, 256);
        gfx.blit(PLAYER, left + 28, top + 145, 0.0f, 0.0f, 176, 90, 256, 256);
    }

    public void containerTick() {
        if (((SimChamberContainer)this.menu).getFailState() != SimChamberTileEntity.FailureState.NONE) {
            SimChamberTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((SimChamberContainer)this.menu).getFailState();
            if (oState != this.lastFailState) {
                this.body.clear();
                MutableComponent msg = Component.translatable((String)this.lastFailState.getKey());
                if (this.lastFailState == SimChamberTileEntity.FailureState.INPUT) {
                    DataModelInstance cModel = new DataModelInstance(((SimChamberContainer)this.menu).getSlot(0).getItem(), 0);
                    Component name = ERROR;
                    if (cModel.isValid()) {
                        name = cModel.getModel().input().getItems()[0].getHoverName();
                    }
                    msg = Component.translatable((String)this.lastFailState.getKey(), (Object[])new Object[]{name});
                }
                this.body.addLine((FormattedText)msg, 1.0f);
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = 300 - ((SimChamberContainer)this.menu).getRuntime();
            float speed = 0.65f;
            this.body.clear();
            int iters = DataModelItem.getIters(((SimChamberContainer)this.menu).getSlot(0).getItem());
            for (int i = 0; i < 7; ++i) {
                MutableComponent txt = Component.translatable((String)("hostilenetworks.run." + i), (Object[])new Object[]{iters});
                this.body.addLine((FormattedText)txt, speed);
                if (i == 0) {
                    MutableComponent version = Component.literal((String)("v" + HostileNetworks.VERSION)).withStyle(ChatFormatting.GOLD);
                    this.body.continueLine((FormattedText)version, speed);
                    continue;
                }
                if (i != 5) continue;
                String key = "hostilenetworks.color_text." + (((SimChamberContainer)this.menu).didPredictionSucceed() ? "success" : "failed");
                MutableComponent status = Component.translatable((String)key).withStyle(((SimChamberContainer)this.menu).didPredictionSucceed() ? ChatFormatting.GOLD : ChatFormatting.RED);
                this.body.continueLine((FormattedText)status, speed);
            }
            this.body.setTicks(ticks);
            this.runtimeTextLoaded = true;
            this.lastFailState = SimChamberTileEntity.FailureState.NONE;
        }
        this.body.tick();
        if (((SimChamberContainer)this.menu).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }

    private class RedstoneButton
    extends AbstractWidget {
        public RedstoneButton(int x, int y) {
            super(x, y, 18, 18, (Component)Component.empty());
        }

        public void onClick(double mouseX, double mouseY) {
            SimChamberScreen scn = SimChamberScreen.this;
            int idx = ((SimChamberContainer)scn.menu).getRedstoneState().next().ordinal();
            ((SimChamberScreen)scn).minecraft.gameMode.handleInventoryButtonClick(((SimChamberContainer)((SimChamberScreen)scn).menu).containerId, idx);
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
            this.defaultButtonNarrationText(output);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.blit(((SimChamberContainer)SimChamberScreen.this.menu).getRedstoneState().getResourceLocation(), this.getX() + 1, this.getY() + 1, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }
}

