/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client.mages;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.client.mages.MageModel;
import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MageRenderer<M extends EntityMageBase>
extends HumanoidMobRenderer<M, MageModel<M>> {
    private static final ResourceLocation fireTexture = ArsElemental.prefix("textures/entity/fire_mage.png");
    private static final ResourceLocation waterTexture = ArsElemental.prefix("textures/entity/water_mage.png");
    private static final ResourceLocation airTexture = ArsElemental.prefix("textures/entity/air_mage.png");
    private static final ResourceLocation earthTexture = ArsElemental.prefix("textures/entity/earth_mage.png");
    private static final ResourceLocation necroTexture = ArsElemental.prefix("textures/entity/necro_mage.png");

    public MageRenderer(EntityRendererProvider.Context context) {
        super(context, new MageModel(context.getModelSet().bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new MageModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new MageModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull M pEntity) {
        return switch (((EntityMageBase)((Object)pEntity)).school.getId()) {
            case "fire" -> fireTexture;
            case "water" -> waterTexture;
            case "air" -> airTexture;
            case "earth" -> earthTexture;
            default -> necroTexture;
        };
    }
}

