/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SporeBlossomGround
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    private static final int ADD_PARTICLE_ATTEMPTS = 7;
    private static final int PARTICLE_XZ_RADIUS = 4;
    private static final int PARTICLE_Y_MAX = 4;

    public SporeBlossomGround(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.below()).isAir() && !level.isWaterAt(pos) && level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState p_154713_, @NotNull Direction p_154714_, @NotNull BlockState p_154715_, @NotNull LevelAccessor p_154716_, @NotNull BlockPos p_154717_, @NotNull BlockPos p_154718_) {
        return p_154714_ == Direction.DOWN && !this.canSurvive(p_154713_, (LevelReader)p_154716_, p_154717_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_154713_, p_154714_, p_154715_, p_154716_, p_154717_, p_154718_);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, RandomSource random) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        double d0 = (double)i + random.nextDouble();
        double d1 = (double)j + 1.0;
        double d2 = (double)k + random.nextDouble();
        level.addParticle((ParticleOptions)ParticleTypes.FALLING_SPORE_BLOSSOM, d0, d1, d2, ParticleUtil.inRange((double)-0.1, (double)0.1), 0.0, ParticleUtil.inRange((double)-0.1, (double)0.1));
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 7; ++l) {
            mutableBlockPos.set(i + Mth.nextInt((RandomSource)random, (int)-4, (int)4), j + random.nextInt(4), k + Mth.nextInt((RandomSource)random, (int)-4, (int)4));
            BlockState blockstate = level.getBlockState((BlockPos)mutableBlockPos);
            if (blockstate.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)mutableBlockPos)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (double)mutableBlockPos.getX() + random.nextDouble(), (double)mutableBlockPos.getY() + random.nextDouble(), (double)mutableBlockPos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState p_154699_, @NotNull BlockGetter p_154700_, @NotNull BlockPos p_154701_, @NotNull CollisionContext p_154702_) {
        return SHAPE;
    }
}

