/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.upstream;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.blocks.upstream.UpstreamTile;
import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MagmaUpstreamTile
extends UpstreamTile {
    public MagmaUpstreamTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.LAVA_UPSTREAM_TILE.get(), pPos, pBlockState);
    }

    @Override
    protected boolean isValidTarget(LivingEntity entity) {
        return !entity.isSpectator() && entity.isInLava() && !entity.isCrouching();
    }

    @Override
    protected int getSourceCost(int power) {
        return (Integer)ConfigHandler.Common.LAVA_ELEVATOR_COST.get() * power;
    }

    @Override
    protected void applyEffects(ServerLevel level, LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100));
        Vec3 vec3 = entity.getDeltaMovement();
        entity.setDeltaMovement(vec3.x, 0.4, vec3.z);
        entity.resetFallDistance();
        for (int i = 0; i < 3; ++i) {
            this.elevatorParticles((Entity)entity, level);
        }
        entity.hurtMarked = true;
    }

    @Override
    public void elevatorParticles(Entity e, ServerLevel level) {
        double d0 = e.getX();
        double d1 = e.getY();
        double d2 = e.getZ();
        level.sendParticles((ParticleOptions)ParticleTypes.LANDING_LAVA, d0 + ParticleUtil.inRange((double)-0.5, (double)0.5), d1 + 1.0, d2 + ParticleUtil.inRange((double)-0.5, (double)0.5), 2, 0.0, 0.0, 0.0, 0.5);
    }
}

