/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.util.EasingManager;
import com.hollingsworth.arsnouveau.common.util.EasingType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityLerpedProjectile
extends ColoredProjectile {
    public static final EntityDataAccessor<BlockPos> to = SynchedEntityData.defineId(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<BlockPos> from = SynchedEntityData.defineId(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.defineId(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> DIDOFFSET = SynchedEntityData.defineId(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int age;
    int maxAge;
    boolean wentUp;

    public EntityLerpedProjectile(Level worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vec3i(from.getX(), from.getY(), from.getZ()), new Vec3i(to.getX(), to.getY(), to.getZ()), 255, 25, 180);
    }

    public EntityLerpedProjectile(Level worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vec3i(from.getX(), from.getY(), from.getZ()), new Vec3i(to.getX(), to.getY(), to.getZ()), r, g, b);
    }

    public EntityLerpedProjectile(EntityType<EntityLerpedProjectile> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    public EntityLerpedProjectile(Level worldIn, Vec3i from, Vec3i to, int r, int g, int b) {
        super((EntityType)ModEntities.LERP_PROJECTILE.get(), worldIn);
        this.entityData.set(EntityFollowProjectile.to, (Object)new BlockPos(to));
        this.entityData.set(EntityFollowProjectile.from, (Object)new BlockPos(from));
        this.maxAge = from.distManhattan(to) * 5;
        this.setPos((double)from.getX() + 0.5, from.getY(), (double)from.getZ() + 0.5);
        this.entityData.set(RED, (Object)r);
        this.entityData.set(GREEN, (Object)g);
        this.entityData.set(BLUE, (Object)b);
    }

    public static float lerp(double percentCompleted, double startValue, double endValue, EasingType type) {
        if (percentCompleted >= 1.0) {
            return (float)endValue;
        }
        percentCompleted = EasingManager.ease((double)percentCompleted, (EasingType)type, null);
        return (float)EntityLerpedProjectile.lerpInternal(percentCompleted, startValue, endValue);
    }

    public static double lerpInternal(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public double normalize(double value, double min, double max) {
        return 1.0 - (value - min) / (max - min);
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.age > 400) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Vec3 vec3d2 = this.getDeltaMovement();
        BlockPos start = (BlockPos)this.entityData.get(from);
        BlockPos end = (BlockPos)this.entityData.get(to);
        if (BlockUtil.distanceFrom((BlockPos)this.blockPosition(), (BlockPos)end) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom((BlockPos)this.blockPosition(), (BlockPos)end) > 16.0) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        double posX = this.getX();
        double posZ = this.getZ();
        double time = 1.0 - this.normalize(this.age, 0.0, 80.0);
        EasingType type = EasingType.EaseOutExpo;
        double startY = start.getY();
        double endY = (double)end.getY() + this.getDistanceAdjustment(start, end);
        double lerpX = EntityLerpedProjectile.lerp(time, (double)start.getX() + 0.5, (double)end.getX() + 0.5, type);
        double lerpY = EntityLerpedProjectile.lerp(time, EntityLerpedProjectile.lerp(time, startY, endY, type), EntityLerpedProjectile.lerp(time, endY, startY, type), type);
        double lerpZ = EntityLerpedProjectile.lerp(time, (double)start.getZ() + 0.5, (double)end.getZ() + 0.5, type);
        BlockPos adjustedPos = new BlockPos(Mth.floor((double)posX), end.getY(), Mth.floor((double)posZ));
        if (BlockUtil.distanceFrom((BlockPos)adjustedPos, (BlockPos)end) <= 0.5) {
            double posY = this.getY() - 0.05;
            this.setPos(lerpX, posY, lerpZ);
        } else {
            this.setPos(lerpX, lerpY, lerpZ);
        }
        if (this.level().isClientSide && this.age > 1) {
            double deltaX = this.getX() - this.xOld;
            double deltaY = this.getY() - this.yOld;
            double deltaZ = this.getZ() - this.zOld;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.level().random.nextInt(3)) % (((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId()) != 0) continue;
                this.level().addParticle(GlowParticleData.createData((ParticleColor)new ParticleColor(((Integer)this.entityData.get(RED)).intValue(), ((Integer)this.entityData.get(GREEN)).intValue(), ((Integer)this.entityData.get(BLUE)).intValue())), (double)((float)(this.xo + deltaX * coeff)), (double)((float)(this.yo + deltaY * coeff)), (double)((float)(this.zo + deltaZ * coeff)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
            }
        }
    }

    public void setDistanceAdjust(float offset) {
        this.entityData.set(OFFSET, (Object)Float.valueOf(offset));
        this.entityData.set(DIDOFFSET, (Object)true);
    }

    private double getDistanceAdjustment(BlockPos start, BlockPos end) {
        if (((Boolean)this.entityData.get(DIDOFFSET)).booleanValue()) {
            return ((Float)this.entityData.get(OFFSET)).floatValue();
        }
        double distance = BlockUtil.distanceFrom((BlockPos)start, (BlockPos)end);
        if (distance <= 1.5) {
            return 2.5;
        }
        return 3.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(to, (Object)new BlockPos(0, 0, 0));
        entityData.define(from, (Object)new BlockPos(0, 0, 0));
        entityData.define(OFFSET, (Object)Float.valueOf(0.0f));
        entityData.define(DIDOFFSET, (Object)false);
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.LERP_PROJECTILE.get();
    }
}

