/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectConflagrate
extends ElementalAbstractEffect
implements IDamageEffect {
    public static EffectConflagrate INSTANCE = new EffectConflagrate();

    public EffectConflagrate() {
        super("conflagrate", "Conflagrate");
    }

    public String getBookDescription() {
        return "When it hits a target on fire, it causes a detonation that deals damage to all entities in range and sets them on fire. That explosion might spread explosive powder on them, causing them to explode after a while.";
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level level, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        block7: {
            block6: {
                Entity entity = rayTraceResult.getEntity();
                if (!(entity instanceof LivingEntity)) break block6;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block7;
            }
            return;
        }
        ServerLevel world = (ServerLevel)level;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        double range = 3.0 + spellStats.getAoeMultiplier();
        DamageSource source = this.buildDamageSource((Level)world, shooter);
        if (livingEntity.isOnFire() && this.attemptDamage((Level)world, shooter, spellStats, spellContext, resolver, (Entity)livingEntity, source, damage)) {
            world.sendParticles((ParticleOptions)ParticleTypes.FLAME, vec.x, vec.y + 0.5, vec.z, 50, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.3);
            world.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, vec.x, vec.y + 0.5, vec.z, 50, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.3);
            for (Entity e : world.getEntities((Entity)shooter, new AABB(livingEntity.position().add(range, range, range), livingEntity.position().subtract(range, range, range)))) {
                e.setRemainingFireTicks(e.getRemainingFireTicks() + 60);
                if (e.equals((Object)livingEntity) || !(e instanceof LivingEntity)) continue;
                LivingEntity liv = (LivingEntity)e;
                if (!this.attemptDamage((Level)world, shooter, spellStats, spellContext, resolver, e, source, damage * 0.75f)) continue;
                if (e.getRandom().nextDouble() > 0.9) {
                    liv.addEffect(new MobEffectInstance((Holder)ModPotions.BLAST_EFFECT, 200, 0));
                }
                vec = e.position();
                world.sendParticles((ParticleOptions)ParticleTypes.FLAME, vec.x, vec.y + 0.5, vec.z, 50, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.3);
            }
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        return DamageUtil.source((LevelAccessor)world, (ResourceKey)DamageTypesRegistry.FLARE, (Entity)shooter);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 9.0);
        this.addAmpConfig(builder, 5.0);
    }

    public int getDefaultManaCost() {
        return 80;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE, AugmentRandomize.INSTANCE});
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the range of the conflagration.");
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_FIRE});
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }
}

