/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.registry;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.CasterHolderContainer;
import alexthw.ars_elemental.common.CurioHolderContainer;
import alexthw.ars_elemental.common.components.ElementProtectionFlag;
import alexthw.ars_elemental.common.items.CasterHolder;
import alexthw.ars_elemental.common.items.CurioHolder;
import alexthw.ars_elemental.common.items.Debugger;
import alexthw.ars_elemental.common.items.armor.AAMaterials;
import alexthw.ars_elemental.recipe.ConfigCondition;
import alexthw.ars_elemental.recipe.HeadCutRecipe;
import alexthw.ars_elemental.recipe.NetheriteUpgradeRecipe;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModParticles;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModTiles;
import alexthw.ars_elemental.util.CompatUtils;
import alexthw.ars_elemental.util.SupplierBlockStateProviderAE;
import alexthw.ars_elemental.world.ModWorldgen;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRegistry {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"ars_elemental");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"ars_elemental");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ars_elemental");
    public static final DeferredRegister<DataComponentType<?>> D_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"ars_elemental");
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((ResourceKey)Registries.ENCHANTMENT, (String)"ars_elemental");
    public static final DeferredRegister<BlockStateProviderType<?>> BS_PROVIDERS = DeferredRegister.create((ResourceKey)Registries.BLOCK_STATE_PROVIDER_TYPE, (String)"ars_elemental");
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"ars_elemental");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"ars_elemental");
    public static final TagKey<Item> BLACKLIST_BAGGABLE = ItemTags.create((ResourceLocation)ArsElemental.prefix("blacklist_bag_item"));
    public static final TagKey<Item> SOULBOUND_ABLE = ItemTags.create((ResourceLocation)ArsElemental.prefix("soulbound_extra"));
    public static final TagKey<EntityType<?>> ATTRACT_BLACKLIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ArsElemental.prefix("attraction_ritual_blacklist"));
    public static final TagKey<EntityType<?>> CHARM_BLACKLIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ArsElemental.prefix("charm_blacklist"));
    public static final TagKey<EntityType<?>> FIERY = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ArsElemental.prefix("fiery"));
    public static final TagKey<EntityType<?>> AERIAL = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ArsElemental.prefix("aerial"));
    public static final TagKey<EntityType<?>> INSECT = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ArsElemental.prefix("insect"));
    public static final ResourceKey<DamageType> CUT = ModRegistry.key(Registries.DAMAGE_TYPE, "beheading");
    public static final ResourceKey<DamageType> POISON = ModRegistry.key(Registries.DAMAGE_TYPE, "poison");
    public static final ResourceKey<DamageType> MAGIC_FIRE = ModRegistry.key(Registries.DAMAGE_TYPE, "hellfire");
    public static final ResourceKey<DamageType> SPARK = ModRegistry.key(Registries.DAMAGE_TYPE, "spark");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ELEMENTAL_TAB;
    public static final DeferredHolder<MenuType<?>, MenuType<CurioHolderContainer>> CURIO_HOLDER;
    public static final DeferredHolder<MenuType<?>, MenuType<CasterHolderContainer>> CASTER_HOLDER;
    public static final DeferredHolder<BlockStateProviderType<?>, BlockStateProviderType<?>> AE_BLOCKSTATE_PROVIDER;
    public static final ResourceKey<Enchantment> MIRROR;
    public static final ResourceKey<Enchantment> SOULBOUND;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ElementProtectionFlag>> P4E;
    public static final DeferredHolder<RecipeType<?>, RecipeType<NetheriteUpgradeRecipe>> NETHERITE_UP;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<NetheriteUpgradeRecipe>> NETHERITE_UP_SERIALIZER;
    public static final DeferredHolder<RecipeType<?>, RecipeType<HeadCutRecipe>> HEAD_CUT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<HeadCutRecipe>> HEAD_CUT_SERIALIZER;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigCondition>> AE_CONFIG_CONDITION;

    public static void registerRegistries(IEventBus bus) {
        AAMaterials.A_MATERIALS.register(bus);
        ModItems.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        ModEntities.ENTITIES.register(bus);
        ModTiles.TILES.register(bus);
        CONTAINERS.register(bus);
        ModParticles.PARTICLES.register(bus);
        ModPotions.EFFECTS.register(bus);
        ModPotions.POTIONS.register(bus);
        ENCHANTMENTS.register(bus);
        ATTRIBUTES.register(bus);
        RECIPES.register(bus);
        SERIALIZERS.register(bus);
        ModWorldgen.FEATURES.register(bus);
        BS_PROVIDERS.register(bus);
        TABS.register(bus);
        D_COMPONENTS.register(bus);
        bus.addListener(ModTiles::addBlocksToTiles);
    }

    static <T> ResourceKey<T> key(ResourceKey<Registry<T>> registryResourceKey, String name) {
        return ResourceKey.create(registryResourceKey, (ResourceLocation)ArsElemental.prefix(name));
    }

    static {
        MIRROR = ModRegistry.key(Registries.ENCHANTMENT, "mirror_shield");
        SOULBOUND = ModRegistry.key(Registries.ENCHANTMENT, "soulbound");
        P4E = D_COMPONENTS.register("p4e", () -> DataComponentType.builder().persistent(ElementProtectionFlag.CODEC).networkSynchronized(ElementProtectionFlag.STREAM_CODEC).build());
        AE_CONFIG_CONDITION = com.alexthw.sauce.registry.ModRegistry.CONDITION_CODECS.register("ae_config", () -> ConfigCondition.CODEC);
        CURIO_HOLDER = CONTAINERS.register("curio_holder", () -> IMenuTypeExtension.create((id, inv, extraData) -> {
            ItemStack stack;
            int slot = extraData.readInt();
            ItemStack itemStack = stack = slot < 0 ? CompatUtils.getCurio((LivingEntity)inv.player, i -> i.getItem() instanceof CurioHolder).stack() : inv.getItem(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof CurioHolder)) {
                stack = ((CurioHolder)((Object)((Object)((Object)ModItems.CURIO_BAG.get())))).getDefaultInstance();
            }
            return new CurioHolderContainer(id, inv, stack);
        }));
        CASTER_HOLDER = CONTAINERS.register("caster_holder", () -> IMenuTypeExtension.create((id, inv, extraData) -> {
            ItemStack stack;
            int slot = extraData.readInt();
            ItemStack itemStack = stack = slot < 0 ? CompatUtils.getCurio((LivingEntity)inv.player, i -> i.getItem() instanceof CasterHolder).stack() : inv.getItem(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof CasterHolder)) {
                stack = ((CasterHolder)((Object)((Object)((Object)ModItems.CASTER_BAG.get())))).getDefaultInstance();
            }
            return new CasterHolderContainer(id, inv, stack);
        }));
        AE_BLOCKSTATE_PROVIDER = BS_PROVIDERS.register("ae_stateprovider", () -> new BlockStateProviderType(SupplierBlockStateProviderAE.CODEC));
        HEAD_CUT = RECIPES.register("head_cut", () -> RecipeType.simple((ResourceLocation)ArsElemental.prefix("head_cut")));
        HEAD_CUT_SERIALIZER = SERIALIZERS.register("head_cut", HeadCutRecipe.Serializer::new);
        NETHERITE_UP = RECIPES.register("netherite_upgrade", () -> RecipeType.simple((ResourceLocation)ArsElemental.prefix("netherite_upgrade")));
        NETHERITE_UP_SERIALIZER = SERIALIZERS.register("netherite_upgrade", NetheriteUpgradeRecipe.Serializer::new);
        ELEMENTAL_TAB = TABS.register("general", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.ars_elemental")).icon(() -> ((Debugger)((Object)((Object)((Object)ModItems.DEBUG_ICON.get())))).getDefaultInstance()).displayItems((params, output) -> {
            for (DeferredHolder entry : ModItems.ITEMS.getEntries()) {
                output.accept(((Item)entry.get()).getDefaultInstance());
            }
        }).withTabsBefore(new ResourceLocation[]{CreativeTabRegistry.BLOCKS.getId()}).build());
    }
}

