/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.SupplierBlockStateProviderAE;
import alexthw.ars_elemental.world.BlackstoneFormation;
import alexthw.ars_elemental.world.QuartzSpikeFeature;
import alexthw.ars_elemental.world.SourcestoneFormationFeature;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.LightBlock;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.world.feature.LightFeature;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.common.world.tree.SupplierBlockStateProvider;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import com.hollingsworth.arsnouveau.setup.registry.WorldgenRegistry;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModWorldgen {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"ars_elemental");
    public static final String SIMPLE_FLASHING_ID = "simple_flashing";
    public static final String COMMON_FLASHING_ID = "common_flashing";
    public static final String RARE_RANDOM_FLASHING_ID = "random_simple_flashing";
    public static final String COMMON_RANDOM_FLASHING_ID = "random_common_flashing";
    public static final String FINAL_RARE_FLASHING = "flashing_archwood";
    public static final String FINAL_COMMON_FLASHING = "common_flashing_archwood";
    public static final String FINAL_CLUSTER_FLASHING = "cluster_flashing_archwood";
    public static final String FINAL_CLUSTER_CASCADING = "cluster_cascading_archwood";
    public static final String FINAL_CLUSTER_BLAZING = "cluster_blazing_archwood";
    public static final String FINAL_CLUSTER_FLOURISHING = "cluster_flourishing_archwood";
    public static final String FINAL_CLUSTER_VEXING = "cluster_vexing_archwood";
    public static final String FINAL_CAVE_VEXING = "cave_vexing_archwood";
    public static final String FINAL_SHORT_VEXING = "short_vexing_archwood";
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_FLOREST_FLOWERS = ModWorldgen.registerPlacedKey("mojang_forest_flowers");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_PUMPKINS = ModWorldgen.registerPlacedKey("mojang_pumpkins");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_SUGAR_CANE = ModWorldgen.registerPlacedKey("mojang_sugar_cane");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_BROWN_MUSHROOM = ModWorldgen.registerPlacedKey("mojang_brown_mushroom");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_RED_MUSHROOM = ModWorldgen.registerPlacedKey("mojang_red_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHORT_VEXING_TREE = ModWorldgen.registerConfKey("short_vexing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CAVE_VEXING_TREE = ModWorldgen.registerConfKey("cave_vexing_tree");
    public static final ResourceKey<PlacedFeature> VEXING_CONFIGURED_CAVE = ModWorldgen.registerPlacedKey("cave_vexing_archwood");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLASHING_TREE_SAPLING = ModWorldgen.registerConfKey("flashing_tree_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_FLASHING_TREE = ModWorldgen.registerConfKey("natural_flashing_tree");
    public static final ResourceKey<PlacedFeature> VEXING_CONFIGURED_SHORT = ModWorldgen.registerPlacedKey("short_vexing_archwood");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOURCESTONE_FORMATION = ModWorldgen.registerConfKey("sourcestone_formation");
    public static final ResourceKey<PlacedFeature> SIMPLE_FLASHING_PLACED = ModWorldgen.registerPlacedKey("simple_flashing");
    public static final ResourceKey<PlacedFeature> COMMON_FLASHING_PLACED = ModWorldgen.registerPlacedKey("common_flashing");
    public static final ResourceKey<PlacedFeature> LESS_MANGROVE_PLACED = ModWorldgen.registerPlacedKey("less_trees_mangrove");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RARE_FLASHING_TREES = ModWorldgen.registerConfKey("random_simple_flashing");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COMMON_FLASHING_TREES = ModWorldgen.registerConfKey("random_common_flashing");
    public static final ResourceKey<PlacedFeature> RARE_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("flashing_archwood");
    public static final ResourceKey<PlacedFeature> COMMON_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("common_flashing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_flashing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_BLAZING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_blazing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_CASCADING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_cascading_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_FLOURISHING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_flourishing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_VEXING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_vexing_archwood");
    public static final ResourceKey<PlacedFeature> SOURCESTONE_FORMATION_PLACED = ModWorldgen.registerPlacedKey("sourcestone_formation_placed");
    public static final DeferredHolder<Feature<?>, SourcestoneFormationFeature> SOURCESTONE_SPIKE = FEATURES.register("sourcestone_spike", () -> new SourcestoneFormationFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> POOLS_WITH_DRIP = ModWorldgen.registerConfKey("pools_with_drip");
    public static final ResourceKey<PlacedFeature> POOLS_WITH_DRIP_PLACED = ModWorldgen.registerPlacedKey("pools_with_drip_placed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKSTONE_ROCK = ModWorldgen.registerConfKey("blackstone_rock");
    public static final ResourceKey<PlacedFeature> BLACKSTONE_ROCK_PLACED = ModWorldgen.registerPlacedKey("blackstone_rock_placed");
    public static final DeferredHolder<Feature<?>, BlackstoneFormation> BLACKSTONE_SPIKE = FEATURES.register("blackstone_formation", () -> new BlackstoneFormation((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> QUARTZ_ROCK = ModWorldgen.registerConfKey("quartz_rock");
    public static final ResourceKey<PlacedFeature> QUARTZ_ROCK_PLACED = ModWorldgen.registerPlacedKey("quartz_rock_placed");
    public static final DeferredHolder<Feature<?>, QuartzSpikeFeature> QUARTZ_SPIKE = FEATURES.register("quartz_spike", () -> new QuartzSpikeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SOURCESTONE = ModWorldgen.registerConfKey("ore_sourcestone");
    public static final ResourceKey<PlacedFeature> ORE_SOURCESTONE_PLACED = ModWorldgen.registerPlacedKey("ore_sourcestone_placed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CAVE_LIGHTS = ModWorldgen.registerConfKey("configured_cave_lights");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTS_UNDERGROUND = ModWorldgen.registerPlacedKey("placed_lights_underground");
    public static final DeferredHolder<Feature<?>, LightFeature> LIGHT_FEATURE = FEATURES.register("light_feature", () -> new LightFeature(BlockStateConfiguration.CODEC){

        public boolean place(BlockStateConfiguration config, WorldGenLevel seed, ChunkGenerator chunkGenerator, RandomSource rand, BlockPos pos) {
            int tries = 0;
            while (true) {
                if (tries >= 20 || !(pos.getY() >= 0 ? !seed.isEmptyBlock(pos) || seed.isWaterAt(pos) : !seed.isEmptyBlock(pos) || seed.isEmptyBlock(pos.below()) || seed.isWaterAt(pos))) {
                    if (pos.getY() <= -48 || pos.getY() >= 48 || !seed.isEmptyBlock(pos) || seed.isWaterAt(pos)) {
                        return false;
                    }
                    seed.setBlock(pos, config.state, 4);
                    this.onStatePlace(seed, chunkGenerator, rand, pos, config);
                    return true;
                }
                ++tries;
                pos = pos.below();
            }
        }
    });
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_TORCHFLOWER = ModWorldgen.registerConfKey("single_torchflower");
    public static final ResourceKey<PlacedFeature> SCATTERED_TORCHFLOWERS = ModWorldgen.registerPlacedKey("scattered_torchflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_SPARKFLOWER = ModWorldgen.registerConfKey("single_sparkflower");
    public static final ResourceKey<PlacedFeature> SCATTERED_SPARKFLOWERS = ModWorldgen.registerPlacedKey("scattered_sparkflowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_BLOSSOM = ModWorldgen.registerConfKey("single_blossom");
    public static final ResourceKey<PlacedFeature> SCATTERED_BLOSSOMS = ModWorldgen.registerPlacedKey("scattered_blossoms");
    public static final ResourceKey<PlacedFeature> LAVA_POOLS = ModWorldgen.registerPlacedKey("lava_pools");
    public static final ResourceKey<PlacedFeature> SPARSE_JUNGLE = ModWorldgen.registerPlacedKey("sparse_jungle_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOURCE_CAVE_VINES = ModWorldgen.registerConfKey("cave_source_vines");
    public static final ResourceKey<PlacedFeature> CEILING_BERRY_CAVE = ModWorldgen.registerPlacedKey("ceiling_berry_cave");
    public static final ResourceKey<PlacedFeature> PLACED_BERRY_BUSH_CAVE = ModWorldgen.registerPlacedKey("placed_berry_bush_cave");
    public static final ResourceKey<ConfiguredWorldCarver<?>> CAVE_CARVER = ResourceKey.create((ResourceKey)Registries.CONFIGURED_CARVER, (ResourceLocation)ArsElemental.prefix("vexing_cave_carver"));

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)name));
    }

    public static void bootstrapCaveCarvers(BootstrapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter holdergetter = context.lookup(Registries.BLOCK);
        context.register(CAVE_CARVER, (Object)WorldCarver.CAVE.configured((CarverConfiguration)new CaveCarverConfiguration(0.2f, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.absolute((int)180)), (FloatProvider)UniformFloat.of((float)2.0f, (float)5.0f), VerticalAnchor.aboveBottom((int)8), CarverDebugSettings.of((boolean)false, (BlockState)BlockRegistry.ARCHWOOD_BUTTON.defaultBlockState()), (HolderSet)holdergetter.getOrThrow(BlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)2.0f, (float)6.0f), (FloatProvider)UniformFloat.of((float)2.0f, (float)6.0f), (FloatProvider)UniformFloat.of((float)-1.0f, (float)-0.4f))));
    }

    public static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placed = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        WorldgenRegistry.bootstrapConfiguredFeatures(context);
        context.register(FLASHING_TREE_SAPLING, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 1, 0, false, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.of((int)0, (int)0), (IntProvider)UniformInt.of((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).ignoreVines().build()));
        context.register(NATURAL_FLASHING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 2, 0, true, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.of((int)0, (int)0), (IntProvider)UniformInt.of((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).build()));
        context.register(RARE_FLASHING_TREES, (Object)new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placed.getOrThrow(SIMPLE_FLASHING_PLACED)}))));
        context.register(COMMON_FLASHING_TREES, (Object)new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placed.getOrThrow(COMMON_FLASHING_PLACED)}))));
        context.register(SHORT_VEXING_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider("purple_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(1, 3, 2, true, ArsNouveau.prefix((String)"bastion_pod").toString()), (BlockStateProvider)new SupplierBlockStateProvider("purple_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.of((int)0, (int)0), (IntProvider)UniformInt.of((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).build()));
        context.register(CAVE_VEXING_TREE, (Object)new ConfiguredFeature(Feature.ROOT_SYSTEM, (FeatureConfiguration)new RootSystemConfiguration(PlacementUtils.inlinePlaced((Holder)holdergetter.getOrThrow(SHORT_VEXING_TREE), (PlacementModifier[])new PlacementModifier[0]), 3, 3, BlockTags.AZALEA_ROOT_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ROOTED_DIRT), 20, 30, 3, 2, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.HANGING_ROOTS), 20, 2, BlockPredicate.allOf((BlockPredicate)BlockPredicate.anyOf((BlockPredicate)BlockPredicate.matchesBlocks(List.of(Blocks.AIR, Blocks.CAVE_AIR, Blocks.VOID_AIR)), (BlockPredicate)BlockPredicate.matchesTag((TagKey)BlockTags.REPLACEABLE_BY_TREES)), (BlockPredicate)BlockPredicate.matchesTag((Vec3i)Direction.DOWN.getNormal(), (TagKey)BlockTags.AZALEA_GROWS_ON)))));
        context.register(POOLS_WITH_DRIP, (Object)new ConfiguredFeature(Feature.WATERLOGGED_VEGETATION_PATCH, (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.GRASS_BLOCK.defaultBlockState(), 75).add((Object)Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 5).add((Object)Blocks.WATER.defaultBlockState(), 20).build()), PlacementUtils.inlinePlaced((Holder)holdergetter.getOrThrow(CaveFeatures.DRIPLEAF), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 3, 0.1f, (IntProvider)UniformInt.of((int)4, (int)7), 0.4f)));
        context.register(BLACKSTONE_ROCK, (Object)new ConfiguredFeature((Feature)((BlackstoneFormation)((Object)BLACKSTONE_SPIKE.get())), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        context.register(QUARTZ_ROCK, (Object)new ConfiguredFeature((Feature)((QuartzSpikeFeature)((Object)QUARTZ_SPIKE.get())), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        context.register(SOURCESTONE_FORMATION, (Object)new ConfiguredFeature((Feature)((SourcestoneFormationFeature)((Object)SOURCESTONE_SPIKE.get())), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        context.register(SINGLE_TORCHFLOWER, (Object)new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.TORCHFLOWER.defaultBlockState()))));
        context.register(SINGLE_SPARKFLOWER, (Object)new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)ModItems.SPARKFLOWER.get()).defaultBlockState()))));
        context.register(SINGLE_BLOSSOM, (Object)new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)ModItems.GROUND_BLOSSOM.get()).defaultBlockState()))));
        context.register(CONFIGURED_CAVE_LIGHTS, (Object)new ConfiguredFeature((Feature)((LightFeature)LIGHT_FEATURE.get()), (FeatureConfiguration)new BlockStateConfiguration(((LightBlock)BlockRegistry.LIGHT_BLOCK.get()).defaultBlockState())));
        WeightedStateProvider weightedstateprovider = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((CaveVinesBlock)ModItems.SOURCE_VINES.get()).defaultBlockState(), 4).add((Object)((BlockState)((CaveVinesPlantBlock)ModItems.SOURCE_VINES_PLANT.get()).defaultBlockState().setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.TRUE)), 1));
        RandomizedIntStateProvider randomizedintstateprovider = new RandomizedIntStateProvider((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((CaveVinesBlock)ModItems.SOURCE_VINES.get()).defaultBlockState(), 4).add((Object)((BlockState)((CaveVinesBlock)ModItems.SOURCE_VINES.get()).defaultBlockState().setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.TRUE)), 1)), CaveVinesBlock.AGE, (IntProvider)UniformInt.of((int)23, (int)25));
        context.register(SOURCE_CAVE_VINES, (Object)new ConfiguredFeature(Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)UniformInt.of((int)0, (int)19), 2).add((Object)UniformInt.of((int)0, (int)2), 3).add((Object)UniformInt.of((int)0, (int)6), 10).build()), (BlockStateProvider)weightedstateprovider), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)randomizedintstateprovider)), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true)));
        context.register(ORE_SOURCESTONE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD), ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"sourcestone"))).defaultBlockState(), 64)));
    }

    public static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        WorldgenRegistry.bootstrapPlacedFeatures(context);
        context.register(SIMPLE_FLASHING_PLACED, (Object)new PlacedFeature((Holder)configured.get(NATURAL_FLASHING_TREE).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
        context.register(COMMON_FLASHING_PLACED, (Object)new PlacedFeature((Holder)configured.get(NATURAL_FLASHING_TREE).get(), List.of(PlacementUtils.countExtra((int)5, (float)0.01f, (int)1), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
        context.register(RARE_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(RARE_FLASHING_TREES).get(), VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)200))));
        context.register(COMMON_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(COMMON_FLASHING_TREES).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)3), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
        context.register(CLUSTER_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(COMMON_FLASHING_TREES).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)4), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
        context.register(CLUSTER_CASCADING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_CASCADING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)4), (Block)((Block)BlockRegistry.CASCADING_SAPLING.get()))));
        context.register(CLUSTER_BLAZING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_BLAZING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)4), (Block)((Block)BlockRegistry.BLAZING_SAPLING.get()))));
        context.register(CLUSTER_FLOURISHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_FLOURISHING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)4), (Block)((Block)BlockRegistry.FLOURISHING_SAPLING.get()))));
        context.register(CLUSTER_VEXING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.NATURAL_CONFIGURED_VEXING_TREE).get(), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)4), (Block)((Block)BlockRegistry.VEXING_SAPLING.get()))));
        context.register(VEXING_CONFIGURED_CAVE, (Object)new PlacedFeature((Holder)configured.get(CAVE_VEXING_TREE).get(), List.of(new PlacementModifier[]{CountPlacement.of((int)105), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()})));
        context.register(VEXING_CONFIGURED_SHORT, (Object)new PlacedFeature((Holder)configured.get(SHORT_VEXING_TREE).get(), List.of(new PlacementModifier[]{CountPlacement.of((int)75), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, SurfaceWaterDepthFilter.forMaxDepth((int)3), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()})));
        context.register(LESS_MANGROVE_PLACED, (Object)new PlacedFeature((Holder)configured.get(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mangrove_vegetation"))).get(), List.of(new PlacementModifier[]{CountPlacement.of((int)5), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)5), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)Blocks.MANGROVE_PROPAGULE.defaultBlockState(), (Vec3i)BlockPos.ZERO), (BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})))})));
        context.register(PLACED_BERRY_BUSH_CAVE, (Object)new PlacedFeature((Holder)configured.get(WorldgenRegistry.PATCH_BERRY_BUSH).get(), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome())));
        context.register(PLACED_LIGHTS_UNDERGROUND, (Object)new PlacedFeature((Holder)configured.get(CONFIGURED_CAVE_LIGHTS).get(), List.of(CountPlacement.of((int)7), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome())));
        context.register(POOLS_WITH_DRIP_PLACED, (Object)new PlacedFeature((Holder)configured.get(POOLS_WITH_DRIP).get(), List.of(new PlacementModifier[]{CountPlacement.of((int)15), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()})));
        context.register(BLACKSTONE_ROCK_PLACED, (Object)new PlacedFeature((Holder)configured.get(BLACKSTONE_ROCK).get(), List.of(new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()})));
        context.register(QUARTZ_ROCK_PLACED, (Object)new PlacedFeature((Holder)configured.get(QUARTZ_ROCK).get(), List.of(new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()})));
        context.register(SOURCESTONE_FORMATION_PLACED, (Object)new PlacedFeature((Holder)configured.get(SOURCESTONE_FORMATION).get(), List.of(new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()})));
        context.register(SCATTERED_TORCHFLOWERS, (Object)new PlacedFeature((Holder)configured.get(SINGLE_TORCHFLOWER).get(), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(SCATTERED_SPARKFLOWERS, (Object)new PlacedFeature((Holder)configured.get(SINGLE_SPARKFLOWER).get(), List.of(CountPlacement.of((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(SCATTERED_BLOSSOMS, (Object)new PlacedFeature((Holder)configured.get(SINGLE_BLOSSOM).get(), List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(LAVA_POOLS, (Object)new PlacedFeature((Holder)configured.get(MiscOverworldFeatures.LAKE_LAVA).get(), List.of(RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(PLACED_MOJANK_FLOREST_FLOWERS, (Object)new PlacedFeature((Holder)configured.get(VegetationFeatures.FOREST_FLOWERS).get(), List.of(RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, CountPlacement.of((IntProvider)ClampedInt.of((IntProvider)UniformInt.of((int)-3, (int)1), (int)0, (int)1)), BiomeFilter.biome())));
        context.register(PLACED_MOJANK_PUMPKINS, (Object)new PlacedFeature((Holder)configured.get(VegetationFeatures.PATCH_PUMPKIN).get(), List.of(RarityFilter.onAverageOnceEvery((int)300), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(PLACED_MOJANK_SUGAR_CANE, (Object)new PlacedFeature((Holder)configured.get(VegetationFeatures.PATCH_SUGAR_CANE).get(), List.of(RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(PLACED_MOJANK_BROWN_MUSHROOM, (Object)new PlacedFeature((Holder)configured.get(VegetationFeatures.PATCH_BROWN_MUSHROOM).get(), List.of(RarityFilter.onAverageOnceEvery((int)256), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(PLACED_MOJANK_RED_MUSHROOM, (Object)new PlacedFeature((Holder)configured.get(VegetationFeatures.PATCH_RED_MUSHROOM).get(), List.of(RarityFilter.onAverageOnceEvery((int)512), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
        context.register(SPARSE_JUNGLE, (Object)new PlacedFeature((Holder)configured.get(VegetationFeatures.TREES_JUNGLE).get(), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)3, (float)0.1f, (int)1))));
        context.register(CEILING_BERRY_CAVE, (Object)new PlacedFeature((Holder)configured.get(SOURCE_CAVE_VINES).get(), List.of(CountPlacement.of((int)88), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome())));
        context.register(ORE_SOURCESTONE_PLACED, (Object)new PlacedFeature((Holder)configured.get(ORE_SOURCESTONE).get(), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)30)), BiomeFilter.biome())));
    }

    public static class Biomes {
        public static final String FLASHING_FOREST_ID = "flashing_forest";
        public static final String BLAZING_FOREST_ID = "blazing_forest";
        public static final String CASCADING_FOREST_ID = "cascading_forest";
        public static final String FLOURISHING_FOREST_ID = "flourishing_forest";
        public static final String VEXING_CAVES_ID = "vexing_caves";
        public static final ResourceKey<Biome> FLASHING_FOREST_KEY = Biomes.register("flashing_forest");
        public static final ResourceKey<Biome> BLAZING_FOREST_KEY = Biomes.register("blazing_forest");
        public static final ResourceKey<Biome> CASCADING_FOREST_KEY = Biomes.register("cascading_forest");
        public static final ResourceKey<Biome> FLOURISHING_FOREST_KEY = Biomes.register("flourishing_forest");
        public static final ResourceKey<Biome> VEXING_CAVES_KEY = Biomes.register("vexing_caves");
        public static final ResourceLocation[] ArchwoodBiomes = new ResourceLocation[]{FLASHING_FOREST_KEY.location(), BLAZING_FOREST_KEY.location(), CASCADING_FOREST_KEY.location(), FLOURISHING_FOREST_KEY.location()};

        public static ResourceKey<Biome> register(String name) {
            return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsElemental.prefix(name));
        }

        public static void registerBiomes(BootstrapContext<Biome> context) {
            BiomeRegistry.bootstrap(context);
            context.register(FLASHING_FOREST_KEY, (Object)Biomes.flashingArchwoodForest(context));
            context.register(BLAZING_FOREST_KEY, (Object)Biomes.blazingArchwoodForest(context));
            context.register(CASCADING_FOREST_KEY, (Object)Biomes.cascadingArchwoodForest(context));
            context.register(FLOURISHING_FOREST_KEY, (Object)Biomes.flourishArchwoodForest(context));
            context.register(VEXING_CAVES_KEY, (Object)Biomes.vexingCaves(context));
        }

        public static Biome flashingArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns((EntityType<EntityMageBase>)((EntityType)ModEntities.AIR_MAGE.get()), (EntityType<WealdWalker>)((EntityType)ModEntities.FLASHING_WEALD_WALKER.get()), null);
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.BREEZE, 5, 1, 1));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 6, 1, 2));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FLASHJACK_ENTITY.get(), 35, 1, 2));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_FLASHING_CONFIGURED, context, QUARTZ_ROCK_PLACED, (ResourceKey<PlacedFeature>)VegetationPlacements.TREES_WINDSWEPT_HILLS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, SCATTERED_SPARKFLOWERS);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.8f).temperature(0.4f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(13414701).foliageColorOverride(13084948).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static Biome blazingArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns((EntityType<EntityMageBase>)((EntityType)ModEntities.FIRE_MAGE.get()), (EntityType<WealdWalker>)((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_BLAZING_WEALD.get()), EntityType.HUSK);
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.ARMADILLO, 6, 1, 2));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_BLAZING_CONFIGURED, context, BLACKSTONE_ROCK_PLACED, (ResourceKey<PlacedFeature>)VegetationPlacements.TREES_WINDSWEPT_SAVANNA);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, SCATTERED_TORCHFLOWERS);
            biomeBuilder.addFeature(GenerationStep.Decoration.LAKES, LAVA_POOLS);
            return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.1f).temperature(0.9f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(13269556).foliageColorOverride(12679744).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static Biome cascadingArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns((EntityType<EntityMageBase>)((EntityType)ModEntities.WATER_MAGE.get()), (EntityType<WealdWalker>)((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_CASCADING_WEALD.get()), EntityType.DROWNED);
            spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.COD, 15, 3, 6));
            spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 15, 1, 5));
            spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 25, 8, 8));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FROG, 6, 1, 3));
            BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
            BiomeRegistry.globalOverworldGeneration((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addExtraGold((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeRegistry.softDisks((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, LESS_MANGROVE_PLACED);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_GRASS_NORMAL);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_DEAD_BUSH);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_WATERLILY);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, POOLS_WITH_DRIP_PLACED);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
            Biomes.addDefaultExtraVegetation(biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WorldgenRegistry.PLACED_LIGHTS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CLUSTER_CASCADING_CONFIGURED);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_GRASS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_FLOWERS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_FLOREST_FLOWERS);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.8f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(1149867).foliageColorOverride(2210437).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static Biome flourishArchwoodForest(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns((EntityType<EntityMageBase>)((EntityType)ModEntities.EARTH_MAGE.get()), (EntityType<WealdWalker>)((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_FLOURISHING_WEALD.get()), EntityType.BOGGED);
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PANDA, 6, 1, 3));
            BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
            BiomeRegistry.globalOverworldGeneration((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addLightBambooVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addExtraGold((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CLUSTER_FLOURISHING_CONFIGURED);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, SPARSE_JUNGLE);
            BiomeDefaultFeatures.addWarmFlowers((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.LUSH_CAVES_CEILING_VEGETATION);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.CAVE_VINES);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.ROOTED_AZALEA_TREE);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.SPORE_BLOSSOM);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.CLASSIC_VINES);
            Biomes.addDefaultExtraVegetation(biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WorldgenRegistry.PLACED_LIGHTS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_GRASS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_FLOWERS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_FLOREST_FLOWERS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, SCATTERED_BLOSSOMS);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.6f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(7978751).waterFogColor(329011).skyColor(7978751).grassColorOverride(1346066).foliageColorOverride(30464).fogColor(12638463).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.ARIA_BIBLIO)).build()).build();
        }

        private static MobSpawnSettings.Builder archwoodSpawns(EntityType<EntityMageBase> mage, EntityType<WealdWalker> ww, EntityType<?> biomeMob) {
            MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
            BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnBuilder);
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 6, 2, 3));
            BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)spawnBuilder);
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 60, 4, 4));
            if (biomeMob != null) {
                spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(biomeMob, 60, 2, 4));
            }
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 20, 4, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_VILLAGER, 5, 1, 1));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 60, 4, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 60, 4, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 40, 4, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 10, 1, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.WITCH, 5, 1, 1));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(mage, 4, 1, 3));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ww, 10, 1, 3));
            return spawnBuilder;
        }

        private static BiomeGenerationSettings.Builder getArchwoodBiomeBuilder(ResourceKey<PlacedFeature> archwoodCluster, BootstrapContext<Biome> context, ResourceKey<PlacedFeature> rock, ResourceKey<PlacedFeature> vanillatree) {
            BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
            BiomeRegistry.globalOverworldGeneration((BiomeGenerationSettings.Builder)biomeBuilder);
            if (rock != null) {
                biomeBuilder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, rock);
            }
            BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.addExtraGold((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeRegistry.softDisks((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, vanillatree);
            Biomes.addDefaultExtraVegetation(biomeBuilder);
            biomeBuilder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WorldgenRegistry.PLACED_LIGHTS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, archwoodCluster);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_GRASS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_FLOWERS);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_FLOREST_FLOWERS);
            return biomeBuilder;
        }

        static void addDefaultExtraVegetation(BiomeGenerationSettings.Builder builder) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_PUMPKINS);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_SUGAR_CANE);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_BROWN_MUSHROOM);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_MOJANK_RED_MUSHROOM);
        }

        public static Biome vexingCaves(BootstrapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 50, 2, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 55, 2, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_VILLAGER, 5, 1, 1));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 50, 2, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 50, 2, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 100, 4, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 30, 1, 4));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.WITCH, 15, 1, 1));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_VEXING_WEALD.get(), 10, 1, 3));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WILDEN_HUNTER.get(), 100, 3, 5));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WILDEN_STALKER.get(), 100, 1, 3));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WILDEN_GUARDIAN.get(), 80, 2, 5));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.AIR_MAGE.get(), 4, 1, 3));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FIRE_MAGE.get(), 4, 1, 3));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WATER_MAGE.get(), 4, 1, 3));
            spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.EARTH_MAGE.get(), 4, 1, 3));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_VEXING_CONFIGURED, context, SOURCESTONE_FORMATION_PLACED, (ResourceKey<PlacedFeature>)CavePlacements.ROOTED_AZALEA_TREE);
            biomeBuilder.addCarver(GenerationStep.Carving.AIR, CAVE_CARVER);
            biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_SOURCESTONE_PLACED);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CEILING_BERRY_CAVE);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_BERRY_BUSH_CAVE);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, PLACED_LIGHTS_UNDERGROUND);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VEXING_CONFIGURED_CAVE);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VEXING_CONFIGURED_SHORT);
            biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, SOURCESTONE_FORMATION_PLACED);
            return new Biome.BiomeBuilder().hasPrecipitation(true).downfall(0.5f).temperature(0.5f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(new BiomeSpecialEffects.Builder().waterColor(12080623).waterFogColor(11832560).skyColor(10979583).grassColorOverride(6566546).foliageColorOverride(8535186).fogColor(14386175).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundRegistry.WILD_HUNT)).build()).build();
        }
    }
}

