/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.processor;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesProcessorTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class VillagerWitchOpenedDoorProcessor
extends StructureProcessor {
    public static final MapCodec<VillagerWitchOpenedDoorProcessor> CODEC = MapCodec.unit(VillagerWitchOpenedDoorProcessor::new);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings structurePlacementData) {
        RandomSource random;
        Block block = currentBlockInfo.state().getBlock();
        if (!(block instanceof DoorBlock) || block.defaultMapColor() != Blocks.SPRUCE_PLANKS.defaultMapColor()) {
            return currentBlockInfo;
        }
        BlockPos.MutableBlockPos doorBlockPos = currentBlockInfo.pos().mutable();
        BlockState doorBlockState = currentBlockInfo.state();
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)doorBlockState.getValue((Property)DoorBlock.HALF);
        BlockPos.MutableBlockPos lowerDoorBlockPos = doorBlockPos.mutable();
        if (doubleBlockHalf == DoubleBlockHalf.UPPER) {
            lowerDoorBlockPos = lowerDoorBlockPos.move(Direction.DOWN);
        }
        boolean isOpened = (random = structurePlacementData.getRandom((BlockPos)lowerDoorBlockPos)).nextFloat() > 0.8f;
        currentBlockInfo = new StructureTemplate.StructureBlockInfo((BlockPos)doorBlockPos, (BlockState)doorBlockState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(isOpened)), null);
        return currentBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return VillagesAndPillagesProcessorTypes.VILLAGE_WITCH_OPENED_DOOR_PROCESSOR;
    }
}

