/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.lucaargolo.mekanismcovers.MekanismCovers;
import dev.lucaargolo.mekanismcovers.MekanismCoversClient;
import dev.lucaargolo.mekanismcovers.mixed.TileEntityTransmitterMixed;
import java.util.List;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.FluidLogType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverItem
extends Item {
    public CoverItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        BlockEntity entity = level.getBlockEntity(pos);
        ItemStack stack = pContext.getItemInHand();
        Block coverBlock = CoverItem.getBlock(stack);
        if (coverBlock != null && entity instanceof TileEntityTransmitterMixed) {
            TileEntityTransmitterMixed transmitter = (TileEntityTransmitterMixed)entity;
            BlockState coverState = coverBlock.getStateForPlacement(new BlockPlaceContext(pContext));
            if (!level.isClientSide) {
                if (transmitter.mekanism_covers$getCoverState() != null) {
                    MekanismCovers.removeCover(level, entity, state, pos, transmitter, true);
                }
                transmitter.mekanism_covers$setCoverState(coverState);
                entity.setChanged();
                stack.shrink(1);
                if (!state.getFluidState().isEmpty()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateHelper.FLUID_LOGGED, (Comparable)FluidLogType.EMPTY));
                }
                level.sendBlockUpdated(pos, state, state, 3);
                AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
                if (lightManager != null) {
                    lightManager.setLightAt(pos, coverState != null ? coverState.getLightEmission((BlockGetter)level, pos) : 0);
                }
                level.getLightEngine().checkBlock(pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Block coverBlock = CoverItem.getBlock(stack);
        if (coverBlock != null) {
            tooltipComponents.add((Component)coverBlock.getName().withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"text.mekanismcovers.empty").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        if (!stack.has(MekanismCovers.COVER_BLOCK)) {
            return null;
        }
        return MekanismCovers.getBlock((ResourceLocation)stack.get(MekanismCovers.COVER_BLOCK));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CoverItemExtensions
    implements IClientItemExtensions {
        @NotNull
        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            final Minecraft minecraft = Minecraft.getInstance();
            return new BlockEntityWithoutLevelRenderer(this, minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

                public void renderByItem(@NotNull ItemStack pStack, @NotNull ItemDisplayContext pDisplayContext, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
                    BakedModel coverStateModel;
                    BlockState coverState;
                    Block coverBlock = CoverItem.getBlock(pStack);
                    boolean transparent = true;
                    if (coverBlock == null) {
                        coverState = Blocks.AIR.defaultBlockState();
                        coverStateModel = minecraft.getModelManager().getModel(MekanismCoversClient.COVER_MODEL);
                        transparent = false;
                    } else {
                        coverState = coverBlock.defaultBlockState();
                        coverStateModel = minecraft.getBlockRenderer().getBlockModel(coverState);
                    }
                    BlockState state = Blocks.AIR.defaultBlockState();
                    BakedModel coverModel = minecraft.getModelManager().getModel(MekanismCoversClient.COVER_MODEL);
                    RenderType renderType = transparent ? RenderType.entityTranslucentCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS) : RenderType.entitySolid((ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                    VertexConsumer consumer = pBuffer.getBuffer(renderType);
                    PoseStack.Pose pose = pPoseStack.last();
                    RandomSource random = RandomSource.create();
                    for (Direction direction : Direction.values()) {
                        random.setSeed(42L);
                        this.renderQuadList(coverState, pose, consumer, coverStateModel.getQuads(coverState, direction, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                    }
                    random.setSeed(42L);
                    this.renderQuadList(coverState, pose, consumer, coverStateModel.getQuads(coverState, null, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                    if (coverStateModel != coverModel) {
                        for (Direction direction : Direction.values()) {
                            random.setSeed(42L);
                            this.renderQuadList(state, pose, consumer, coverModel.getQuads(state, direction, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                        }
                        random.setSeed(42L);
                        this.renderQuadList(state, pose, consumer, coverModel.getQuads(state, null, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                    }
                }

                private void renderQuadList(BlockState state, PoseStack.Pose pose, VertexConsumer consumer, List<BakedQuad> bakedQuads, int light, int overlay) {
                    for (BakedQuad quad : bakedQuads) {
                        float f2;
                        float f1;
                        float f;
                        if (minecraft.level != null && quad.isTinted()) {
                            BlockPos pos = BlockPos.ZERO;
                            if (minecraft.player != null) {
                                pos = minecraft.player.blockPosition();
                            }
                            int i = minecraft.getBlockColors().getColor(state, (BlockAndTintGetter)minecraft.level, pos, quad.getTintIndex());
                            f = (float)(i >> 16 & 0xFF) / 255.0f;
                            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                            f2 = (float)(i & 0xFF) / 255.0f;
                        } else {
                            f = 1.0f;
                            f1 = 1.0f;
                            f2 = 1.0f;
                        }
                        consumer.putBulkData(pose, quad, f, f1, f2, 1.0f, light, overlay);
                    }
                }
            };
        }
    }
}

